/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.steps;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.list.OpenListException;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.jenkinsci.plugins.ibmisteps.Messages;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;
import org.jenkinsci.plugins.ibmisteps.model.LoggerWrapper;
import org.jenkinsci.plugins.ibmisteps.model.SpooledFileHandler;
import org.jenkinsci.plugins.ibmisteps.model.SpooledFiles;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStep;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class IBMiGetSpooledFilesStep
extends IBMiStep<SpooledFiles> {
    private static final long serialVersionUID = 1880307039400864220L;
    private final String jobName;
    private final String jobNumber;
    private final String jobUser;
    private final String to;
    private boolean clearTo;

    @DataBoundConstructor
    public IBMiGetSpooledFilesStep(String jobName, String jobNumber, String jobUser, String to) {
        this.jobName = jobName.trim().toUpperCase();
        this.jobUser = jobUser.trim().toUpperCase();
        this.jobNumber = jobNumber.trim().toUpperCase();
        this.to = to;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobNumber() {
        return this.jobNumber;
    }

    public String getJobUser() {
        return this.jobUser;
    }

    public String getTo() {
        return this.to;
    }

    public boolean isClearTo() {
        return this.clearTo;
    }

    @DataBoundSetter
    public void setClearTo(boolean clearTo) {
        this.clearTo = clearTo;
    }

    @Override
    protected SpooledFiles runOnIBMi(StepContext stepContext, LoggerWrapper logger, IBMi ibmi) throws AS400SecurityException, SQLException, OpenListException, ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException {
        logger.log(Messages.IBMiGetSpooledFiles_getting(this.jobNumber, this.jobUser, this.jobName));
        SpooledFileHandler spooledFileHandler = ibmi.getSpooledFileHandler();
        SpooledFiles spooledFiles = spooledFileHandler.listSpooledFiles(ibmi, this.jobNumber, this.jobUser, this.jobName);
        FilePath toFolder = ((FilePath)stepContext.get(FilePath.class)).child(this.to);
        if (toFolder.exists() && this.clearTo) {
            toFolder.deleteContents();
            logger.trace("Cleared target directory %s", toFolder);
        }
        toFolder.mkdirs();
        for (SpooledFiles.SpooledFile spooledFile : spooledFiles) {
            FilePath toFile = toFolder.child(spooledFile.getFileName());
            logger.trace(MessageFormat.format("Writing {0} ({1}) into {2}", spooledFile.getName(), spooledFile.getNumber(), toFile));
            spooledFileHandler.writeSpooledFile(ibmi, spooledFile, toFile);
        }
        logger.log(Messages.IBMiGetSpooledFiles_count(spooledFiles.size(), toFolder));
        return spooledFiles;
    }

    @Extension
    public static class DescriptorImpl
    extends IBMiStepDescriptor {
        public String getFunctionName() {
            return "ibmiGetSPLF";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.IBMiGetSpooledFiles_description();
        }
    }
}

