/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.model;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import hudson.model.TaskListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;

public class IBMiContext
implements Serializable {
    private static final long serialVersionUID = 7477349510791081645L;
    private final String host;
    private final StandardUsernamePasswordCredentials credentials;
    private final int ccsid;
    private final boolean secure;
    private final String iasp;
    private final boolean traceEnabled;
    private transient IBMi ibmi;

    public IBMiContext(String host, StandardUsernamePasswordCredentials credentials, int ccsid, boolean secure, String iasp, boolean traceEnabled) {
        this.host = host;
        this.credentials = credentials;
        this.ccsid = ccsid;
        this.secure = secure;
        this.iasp = iasp;
        this.traceEnabled = traceEnabled;
    }

    public IBMi getIBMi(TaskListener listener) throws IOException, InterruptedException, PropertyVetoException, AS400SecurityException, ErrorCompletingRequestException {
        if (this.ibmi == null) {
            this.ibmi = new IBMi(listener.getLogger(), this.host, this.credentials, this.ccsid, this.secure, this.traceEnabled);
            this.ibmi.changeIASP(this.iasp);
            this.ibmi.onDisconnected(e -> {
                this.ibmi = null;
            });
        }
        return this.ibmi;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void close() {
        if (this.ibmi != null) {
            this.ibmi.disconnect();
        }
    }
}

