/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.model;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionEvent;
import com.ibm.as400.access.ConnectionListener;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IBMiMessage;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.IFSFileReader;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.SecureAS400;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.FilePath;
import hudson.Util;
import hudson.util.Secret;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.ibmisteps.Messages;
import org.jenkinsci.plugins.ibmisteps.model.CLSpooledFilehandler;
import org.jenkinsci.plugins.ibmisteps.model.CallResult;
import org.jenkinsci.plugins.ibmisteps.model.LoggerWrapper;
import org.jenkinsci.plugins.ibmisteps.model.RowProcessor;
import org.jenkinsci.plugins.ibmisteps.model.SQLSpooledFilehandler;
import org.jenkinsci.plugins.ibmisteps.model.ShellExec;
import org.jenkinsci.plugins.ibmisteps.model.SpooledFileHandler;
import org.jenkinsci.plugins.ibmisteps.model.TempFileTask;

public class IBMi
implements ConnectionListener,
AutoCloseable,
Serializable {
    public static final String SYSBAS = "*SYSBAS";
    private static final long serialVersionUID = -3164250407732394897L;
    private final AS400 ibmiConnection;
    private final transient LoggerWrapper logger;
    private transient Consumer<ConnectionEvent> onConnected;
    private transient Consumer<ConnectionEvent> onDisconnected;
    private transient CharConverter charConverter;
    private int connectionCCSID;
    private String iASP = "*SYSBAS";
    private transient Job commandJob;
    private transient Job databaseJob;
    private transient AS400JDBCConnection sqlConnection;
    private SpooledFileHandler spooledFileHandler;

    public IBMi(PrintStream stream, String host, StandardUsernamePasswordCredentials credentials, int ccsid, boolean secure, boolean doTrace) throws IOException, InterruptedException {
        this.logger = new LoggerWrapper(stream, doTrace);
        this.ibmiConnection = secure ? new SecureAS400() : new AS400();
        try {
            this.connect(host, credentials, ccsid);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(Messages.IBMi_connection_failed(e.toString()), e);
        }
    }

    private void connect(String host, StandardUsernamePasswordCredentials credentials, int ccsid) throws IOException, PropertyVetoException, AS400SecurityException, ObjectDoesNotExistException, InterruptedException, ErrorCompletingRequestException {
        this.ibmiConnection.setGuiAvailable(false);
        if (host != null && !host.isBlank()) {
            this.logger.trace(Messages.IBMi_connect_remote(host, credentials.getUsername()));
            this.ibmiConnection.setSystemName(host);
            this.ibmiConnection.setUserId(credentials.getUsername());
            this.ibmiConnection.setPassword(Secret.toString((Secret)credentials.getPassword()).toCharArray());
        } else {
            this.logger.trace(Messages.IBMi_connect_local());
        }
        int n = this.connectionCCSID = ccsid > 0 ? ccsid : this.getPreferredCCSID();
        if (this.connectionCCSID < 1 || this.connectionCCSID > 65535) {
            throw new IOException(Messages.IBMi_connect_invalid_ccsid(this.connectionCCSID));
        }
        this.ibmiConnection.setCcsid(this.connectionCCSID);
        this.charConverter = new CharConverter(this.connectionCCSID, this.ibmiConnection);
        this.ibmiConnection.connectService(2);
        this.commandJob = this.ibmiConnection.getJobs(2)[0];
        this.logger.trace("Command job is %s", this.commandJob);
        this.setJobCCSID(this.commandJob);
        this.setJobInquiryReply(this.commandJob);
        this.logger.log(Messages.IBMi_connected(this.ibmiConnection.getSystemName(), this.getOSVersion(), this.ibmiConnection.getUserId(), this.connectionCCSID, this.ibmiConnection instanceof SecureAS400 ? Messages.using_ssl() : ""));
    }

    private void createSQLConnection() throws SQLException, AS400SecurityException, ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException {
        this.closeSQLConnection();
        this.logger.trace("Opening SQL connection");
        Properties properties = new Properties();
        properties.put("naming", "system");
        properties.put("prompt", "false");
        properties.put("big decimal", "false");
        if (this.connectionCCSID == 1200) {
            properties.put("package ccsid", String.valueOf(this.connectionCCSID));
        }
        properties.put("translate binary", "true");
        properties.put("keep alive", (Object)true);
        properties.put("block size", (Object)512);
        if (this.ibmiConnection instanceof SecureAS400) {
            properties.put("secure", (Object)true);
        }
        if (!this.isSYSBAS(this.iASP)) {
            try (Connection connection = new AS400JDBCDriver().connect(this.ibmiConnection);
                 Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(String.format("Select RDB_NAME From QSYS2.ASP_INFO Where DEVICE_DESCRIPTION_NAME = '%s' Fetch First row only", this.iASP));){
                if (resultSet.next()) {
                    String databaseName = resultSet.getString(1);
                    this.logger.trace("Database name for iASP %s is %s", this.iASP, databaseName);
                    properties.put("database name", databaseName);
                }
                this.logger.log("No RDB_NAME found for DEVICE_DESCRIPTION_NAME '%s'", this.iASP);
            }
        }
        this.sqlConnection = (AS400JDBCConnection)new AS400JDBCDriver().connect(this.ibmiConnection, properties, null);
        this.sqlConnection.setTransactionIsolation(0);
        String sqlJobIdentifier = this.sqlConnection.getServerJobIdentifier();
        this.databaseJob = new Job(this.ibmiConnection, sqlJobIdentifier.substring(0, 10).trim(), sqlJobIdentifier.substring(10, 20).trim(), sqlJobIdentifier.substring(20, 26).trim());
        this.logger.trace("SQL job is %s", this.databaseJob);
        this.setJobCCSID(this.databaseJob);
    }

    private void setJobInquiryReply(Job job) throws AS400SecurityException, ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException {
        job.setInquiryMessageReply("*DFT");
        job.commitChanges();
    }

    private void setJobCCSID(Job job) throws AS400SecurityException, ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException {
        job.setCodedCharacterSetID(this.connectionCCSID);
        job.commitChanges();
    }

    private int getPreferredCCSID() {
        try {
            int profileCCSID = this.ibmiConnection.getCcsid();
            this.logger.trace("Profile CCSID is %s", profileCCSID);
            if (profileCCSID == 5026) {
                this.logger.log(Messages.IBMi_connect_ccsid_5026());
                int n = 5035;
                return n;
            }
            int n = profileCCSID;
            return n;
        }
        finally {
            this.ibmiConnection.resetAllServices();
        }
    }

    public void changeIASP(String targetIASP) throws PropertyVetoException, AS400SecurityException, IOException, InterruptedException, ErrorCompletingRequestException {
        if (this.isSYSBAS(this.iASP) && !this.isSYSBAS(targetIASP) || !this.isSYSBAS(this.iASP) && this.isSYSBAS(targetIASP) && !Util.fixNull((String)targetIASP).equalsIgnoreCase(Util.fixNull((String)this.iASP))) {
            this.logger.trace("Changing iASP from %s to %s", this.iASP, targetIASP);
            if (this.isSYSBAS(targetIASP)) {
                this.ibmiConnection.setIASPGroup("*NONE");
            } else {
                this.ibmiConnection.setIASPGroup(targetIASP);
                if (!this.ibmiConnection.aspName.equalsIgnoreCase(targetIASP)) {
                    throw new IOException(Messages.IBMi_change_iasp_failed(targetIASP));
                }
            }
            this.iASP = targetIASP;
        }
    }

    private boolean isSYSBAS(String targetIASP) {
        return targetIASP == null || targetIASP.isBlank() || targetIASP.equals("1") || targetIASP.equals(SYSBAS);
    }

    @Override
    public void close() {
        this.disconnect();
    }

    public void disconnect() {
        this.closeSQLConnection();
        if (this.ibmiConnection != null) {
            this.logger.trace("Disconnecting IBM i");
            this.ibmiConnection.disconnectAllServices();
            this.ibmiConnection.removeConnectionListener((ConnectionListener)this);
        }
    }

    private void closeSQLConnection() {
        if (this.sqlConnection != null) {
            this.logger.trace("Closing SQL connection");
            try {
                this.sqlConnection.close();
            }
            catch (SQLException e) {
                this.logger.error(Messages.IBMi_closeSQL_error(e));
            }
            finally {
                this.sqlConnection = null;
                this.databaseJob = null;
            }
        }
    }

    public void onConnected(Consumer<ConnectionEvent> onConnected) {
        this.onConnected = onConnected;
    }

    public void onDisconnected(Consumer<ConnectionEvent> onDisconnected) {
        this.onDisconnected = onDisconnected;
    }

    public void connected(ConnectionEvent event) {
        this.logger.trace("Received connected event for %s", AS400.getServerName((int)event.getService()));
        if (this.onConnected != null) {
            this.onConnected.accept(event);
        }
    }

    public void disconnected(ConnectionEvent event) {
        this.logger.trace("Received disconnected event for %s", AS400.getServerName((int)event.getService()));
        if (this.onDisconnected != null) {
            this.onDisconnected.accept(event);
        }
    }

    public CharConverter getCharConverter() {
        return this.charConverter;
    }

    public int getConnectionCCSID() {
        return this.connectionCCSID;
    }

    public String getiASP() {
        return this.iASP;
    }

    public Job getCommandJob() {
        return this.commandJob;
    }

    public Job getDatabaseJob() {
        return this.databaseJob;
    }

    public AS400JDBCConnection getSqlConnection() throws AS400SecurityException, SQLException, ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException {
        if (this.sqlConnection == null) {
            this.createSQLConnection();
        }
        return this.sqlConnection;
    }

    public AS400JDBCStatement getDB2Statement() throws SQLException, AS400SecurityException, ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException {
        return (AS400JDBCStatement)this.getSqlConnection().createStatement();
    }

    public void executeAndProcessQuery(String query, RowProcessor rowProcessor) throws SQLException, AS400SecurityException, ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException {
        try (AS400JDBCStatement statement = this.getDB2Statement();
             ResultSet resultSet = statement.executeQuery(query);){
            while (resultSet.next()) {
                rowProcessor.processRow(resultSet);
            }
        }
    }

    public synchronized CallResult executeCommand(@CheckForNull String command) throws IOException, AS400SecurityException, ErrorCompletingRequestException, InterruptedException {
        command = Util.fixNull((String)command).trim();
        CommandCall commandCall = new CommandCall(this.ibmiConnection, command);
        commandCall.setMessageOption(2);
        boolean executionOK = commandCall.run();
        return new CallResult(this, executionOK, commandCall.getMessageList());
    }

    public ShellExec executeShellCommand(@CheckForNull String command) throws AS400SecurityException, IOException, InterruptedException, ErrorCompletingRequestException {
        AtomicReference shellResult = new AtomicReference();
        this.withTempFile(tempFile -> {
            this.setEnvironmentVariable("QIBM_QSH_CMD_ESCAPE_MSG", "Y");
            this.setEnvironmentVariable("QIBM_MULTI_THREADED", "Y");
            this.setEnvironmentVariable("QIBM_QSH_CMD_OUTPUT", "'FILE=" + String.valueOf(tempFile) + "'");
            CallResult callResult = this.executeCommand("QSH CMD('" + Util.fixNull((String)command).trim().replace("'", "''") + "')");
            IBMiMessage qsh0005 = callResult.getMessage("QSH0005");
            if (qsh0005 == null) {
                shellResult.set(new ShellExec(-1, callResult.getPrettyMessages()));
            } else {
                try (BufferedReader reader = new BufferedReader((Reader)new IFSFileReader(tempFile));){
                    shellResult.set(new ShellExec(BinaryConverter.byteArrayToInt((byte[])qsh0005.getSubstitutionData(), (int)0), reader.lines().collect(Collectors.joining("\n"))));
                }
            }
        });
        return (ShellExec)shellResult.get();
    }

    public void setEnvironmentVariable(String name, String value) throws AS400SecurityException, IOException, InterruptedException, ErrorCompletingRequestException {
        this.executeCommand("ADDENVVAR ENVVAR(" + name + ") VALUE(" + value + ") REPLACE(*YES)");
    }

    public String getOSVersion() throws AS400SecurityException, IOException {
        return String.format("%s.%s", this.ibmiConnection.getVersion(), this.ibmiConnection.getRelease());
    }

    public AS400 getIbmiConnection() {
        return this.ibmiConnection;
    }

    public void withTempFile(TempFileTask task) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        IFSFile tempFile = new IFSFile(this.ibmiConnection, "/tmp", String.valueOf(UUID.randomUUID()) + ".jenkins.temp");
        if (tempFile.exists()) {
            tempFile.delete();
        }
        try {
            task.run(tempFile);
        }
        finally {
            if (tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    public long download(IFSFile from, FilePath to) throws IOException, AS400SecurityException, InterruptedException {
        try (BufferedInputStream input = new BufferedInputStream((InputStream)new IFSFileInputStream(from));){
            long l;
            try (BufferedOutputStream output = new BufferedOutputStream(to.write());){
                l = this.copy(input, output);
            }
            return l;
        }
    }

    public long upload(FilePath from, IFSFile to) throws IOException, AS400SecurityException, InterruptedException {
        return this.upload(from, to, -1);
    }

    public long upload(FilePath from, IFSFile to, int ccsid) throws IOException, AS400SecurityException, InterruptedException {
        if (to.getParentFile() != null) {
            to.getParentFile().mkdirs();
        }
        try (BufferedInputStream input = new BufferedInputStream(from.read());){
            long l;
            try (BufferedOutputStream output = new BufferedOutputStream((OutputStream)(ccsid > -1 ? new IFSFileOutputStream(to, -1, false, ccsid) : new IFSFileOutputStream(to)));){
                l = this.copy(input, output);
            }
            return l;
        }
    }

    private long copy(InputStream input, OutputStream output) throws IOException {
        int read;
        byte[] buffer = new byte[0x100000];
        long bytes = 0L;
        while ((read = input.read(buffer)) > -1) {
            output.write(buffer, 0, read);
            bytes += (long)read;
        }
        return bytes;
    }

    public SpooledFileHandler getSpooledFileHandler() {
        if (this.spooledFileHandler == null) {
            AtomicInteger checkCount = new AtomicInteger(0);
            try {
                this.executeAndProcessQuery("Select count(*) from QSYS2.sysroutines where routine_name in ('SPOOLED_FILE_DATA', 'SPOOLED_FILE_INFO')", row -> checkCount.set(row.getInt(1)));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.log(Messages.IBMi_failed_sql_service_check(e.getLocalizedMessage()));
            }
            catch (AS400SecurityException | ErrorCompletingRequestException | ObjectDoesNotExistException | IOException | SQLException e) {
                this.logger.log(Messages.IBMi_failed_sql_service_check(e.getLocalizedMessage()));
            }
            if (checkCount.get() == 2) {
                this.logger.trace("Using SQL spooled files handler");
                this.spooledFileHandler = new SQLSpooledFilehandler();
            } else {
                this.logger.trace("Using CL spooled files handler");
                this.spooledFileHandler = new CLSpooledFilehandler();
            }
        }
        return this.spooledFileHandler;
    }
}

