/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.steps;

import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jenkinsci.plugins.ibmisteps.Messages;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;
import org.jenkinsci.plugins.ibmisteps.model.LoggerWrapper;
import org.jenkinsci.plugins.ibmisteps.model.SQLResult;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStep;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;

public class IBMiRunSQLStep
extends IBMiStep<SQLResult> {
    private static final long serialVersionUID = 5802097350903272246L;
    private final String sql;

    @DataBoundConstructor
    public IBMiRunSQLStep(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    @Override
    protected SQLResult runOnIBMi(StepContext context, LoggerWrapper logger, IBMi ibmi) throws SQLException, AS400SecurityException, ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException {
        SQLResult sQLResult;
        block10: {
            logger.log(Messages.IBMiRunSQLStep_running(this.sql));
            AS400JDBCStatement statement = ibmi.getDB2Statement();
            try {
                SQLResult result;
                if (statement.execute(this.sql)) {
                    ResultSet resultSet = statement.getResultSet();
                    result = new SQLResult(resultSet);
                    logger.trace(Messages.IBMiRunSQLStep_rows(result.getRowCount()));
                } else {
                    result = new SQLResult(statement.getUpdateCount());
                    logger.trace(Messages.IBMiRunSQLStep_updated(result.getUpdateCount()));
                }
                sQLResult = result;
                if (statement == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    logger.error(Messages.IBMiRunSQLStep_failed(e.getLocalizedMessage()));
                    throw e;
                }
            }
            statement.close();
        }
        return sQLResult;
    }

    @Extension
    public static class DescriptorImpl
    extends IBMiStepDescriptor {
        public String getFunctionName() {
            return "ibmiRunSQL";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.IBMiRunSQLStep_description();
        }
    }
}

