/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.steps;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.SaveFile;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import java.io.IOException;
import org.jenkinsci.plugins.ibmisteps.Messages;
import org.jenkinsci.plugins.ibmisteps.model.CallResult;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;
import org.jenkinsci.plugins.ibmisteps.model.LoggerWrapper;
import org.jenkinsci.plugins.ibmisteps.model.SaveFileContent;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStep;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;

public class IBMiGetSAVFStep
extends IBMiStep<SaveFileContent> {
    private static final long serialVersionUID = 8285322833287436551L;
    private final String library;
    private final String name;
    private final String toFile;

    @DataBoundConstructor
    public IBMiGetSAVFStep(String library, String name, String toFile) {
        this.library = library.trim().toUpperCase();
        this.name = name.trim().toUpperCase();
        this.toFile = toFile;
    }

    public String getLibrary() {
        return this.library;
    }

    public String getName() {
        return this.name;
    }

    public String getToFile() {
        return this.toFile;
    }

    @Override
    protected SaveFileContent runOnIBMi(StepContext context, LoggerWrapper logger, IBMi ibmi) throws AS400SecurityException, ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException {
        SaveFile saveFile = new SaveFile(ibmi.getIbmiConnection(), this.library, this.name);
        if (!saveFile.exists()) {
            throw new AbortException(Messages.IBMiDownloadSAVF_save_file_not_found(this.library, this.name));
        }
        logger.log(Messages.IBMiDownloadSAVF_downloading(this.library, this.name, this.toFile, saveFile.getLength()));
        ibmi.withTempFile(tempFile -> {
            try {
                String copyCommand = String.format("CPYTOSTMF FROMMBR('%s') TOSTMF('%s') STMFOPT(*REPLACE)", saveFile.getPath(), tempFile.getAbsolutePath());
                logger.trace("Running " + copyCommand);
                CallResult copyResult = ibmi.executeCommand(copyCommand);
                if (!copyResult.isSuccessful()) {
                    throw new AbortException(Messages.IBMiDownloadSAVF_CPYTOSTMF_failed(this.library, this.name, tempFile, copyResult.getPrettyMessages()));
                }
                FilePath workspaceFile = ((FilePath)context.get(FilePath.class)).child(this.toFile);
                logger.trace("Downloading %s to %s", tempFile, workspaceFile);
                ibmi.download(tempFile, workspaceFile);
            }
            catch (AS400SecurityException | ErrorCompletingRequestException e) {
                throw new IOException(e);
            }
        });
        return new SaveFileContent(saveFile);
    }

    @Extension
    public static class DescriptorImpl
    extends IBMiStepDescriptor {
        public String getFunctionName() {
            return "ibmiGetSAVF";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.IBMiDownloadSAVF_description();
        }
    }
}

