/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SQLResult
implements Serializable {
    private static final long serialVersionUID = 6196545312618433171L;
    private final List<SQLColumn> columns = new LinkedList<SQLColumn>();
    private final List<SQLRow> rows = new LinkedList<SQLRow>();
    private final int updateCount;

    public SQLResult(int updateCount) {
        this.updateCount = updateCount;
    }

    public SQLResult(ResultSet resultSet) throws SQLException {
        this(0);
        this.loadMetaData(resultSet.getMetaData());
        while (resultSet.next()) {
            this.loadRow(resultSet);
        }
    }

    private void loadMetaData(ResultSetMetaData metaData) throws SQLException {
        int columnCount = metaData.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            int column = i + 1;
            this.columns.add(new SQLColumn(metaData.getColumnName(column), metaData.getColumnTypeName(column), metaData.getPrecision(column), metaData.getScale(column)));
        }
    }

    private void loadRow(ResultSet resultSet) throws SQLException {
        SQLRow row = new SQLRow();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            row.addCell(this.columns.get(i).name(), resultSet.getObject(i + 1));
        }
        this.rows.add(row);
    }

    public List<SQLColumn> getColumns() {
        return this.columns;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public List<SQLRow> getRows() {
        return this.rows;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public String toCSV() throws IOException {
        CsvMapper csvMapper = new CsvMapper();
        try (StringWriter sw = new StringWriter();){
            String string;
            block12: {
                SequenceWriter sequenceWriter = csvMapper.writer().writeValues((Writer)sw);
                try {
                    sequenceWriter.write(this.columns.stream().map(SQLColumn::name).toList());
                    for (SQLRow row : this.rows) {
                        sequenceWriter.write(row.getCells().values().stream().map(String::valueOf).toList());
                    }
                    string = sw.toString();
                    if (sequenceWriter == null) break block12;
                }
                catch (Throwable throwable) {
                    if (sequenceWriter != null) {
                        try {
                            sequenceWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                sequenceWriter.close();
            }
            return string;
        }
    }

    public String toJSON() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.writeValueAsString(this.rows.stream().map(SQLRow::getCells).toList());
    }

    public record SQLColumn(String name, String typeName, int size, int scale) implements Serializable
    {
    }

    public static class SQLRow
    implements Serializable {
        private static final long serialVersionUID = 3759165044341489985L;
        private final Map<String, Object> cells = new LinkedHashMap<String, Object>();

        void addCell(String name, Object value) {
            this.cells.put(name, value);
        }

        public Map<String, Object> getCells() {
            return this.cells;
        }

        @CheckForNull
        public Object get(String column) {
            return this.cells.get(column);
        }

        @CheckForNull
        public String getString(String column) {
            return String.valueOf(this.cells.get(column));
        }

        @CheckForNull
        public Integer getInt(String column) {
            return this.get(column, Integer.class);
        }

        @CheckForNull
        public Double getDouble(String column) {
            return this.get(column, Double.class);
        }

        @CheckForNull
        public Float getFloat(String column) {
            return this.get(column, Float.class);
        }

        @CheckForNull
        public Short getShort(String column) {
            return this.get(column, Short.class);
        }

        @CheckForNull
        public BigDecimal getBigDecimal(String column) {
            return this.get(column, BigDecimal.class);
        }

        @CheckForNull
        public Date getDate(String column) {
            return this.get(column, Date.class);
        }

        @CheckForNull
        public Time getTime(String column) {
            return this.get(column, Time.class);
        }

        @CheckForNull
        public Timestamp getTimeStamp(String column) {
            return this.get(column, Timestamp.class);
        }

        private <T> T get(String column, Class<T> clazz) {
            return Optional.ofNullable(this.cells.get(column)).filter(clazz::isInstance).map(clazz::cast).orElse(null);
        }
    }
}

