/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.configuration;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.ibmisteps.Messages;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.core.Authentication;

public class IBMiServerConfiguration
extends AbstractDescribableImpl<IBMiServerConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(IBMiServerConfiguration.class.getName());
    private final String name;
    private final String host;
    private final String credentialsId;
    private final String ccsid;
    private final boolean secure;

    @DataBoundConstructor
    public IBMiServerConfiguration(String name, String host, String credentialsId, String ccsid, boolean secure) {
        this.name = name;
        this.host = host;
        this.credentialsId = credentialsId;
        this.ccsid = ccsid;
        this.secure = secure;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getCcsid() {
        return this.ccsid;
    }

    public int getCcsidInt() {
        try {
            if (this.ccsid != null && !this.ccsid.isBlank()) {
                return Integer.parseInt(this.ccsid);
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean equals(Object other) {
        if (other instanceof IBMiServerConfiguration) {
            IBMiServerConfiguration otherServer = (IBMiServerConfiguration)((Object)other);
            return this.name.equals(otherServer.name) && this.host.equals(otherServer.host) && this.credentialsId.equals(otherServer.credentialsId) && this.ccsid.equals(otherServer.ccsid) && this.secure == otherServer.secure;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.host, this.credentialsId, this.ccsid, this.secure);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<IBMiServerConfiguration> {
        @RequirePOST
        public final ListBoxModel doFillCredentialsIdItems(@QueryParameter String value) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(value);
            }
            return new StandardUsernameListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, (ItemGroup)Jenkins.get(), StandardUsernamePasswordCredentials.class, Collections.emptyList(), CredentialsMatchers.always());
        }

        @RequirePOST
        public FormValidation doCheckCredentialsId(@QueryParameter String credentialsId) {
            if (credentialsId == null || credentialsId.isBlank()) {
                return FormValidation.error((String)Messages.IBMiServer_credentials_required());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckCcsid(@QueryParameter String ccsid) {
            if (ccsid != null && !ccsid.isBlank()) {
                try {
                    int ccsidNumber = Integer.parseInt(ccsid);
                    if (ccsidNumber < 0 || ccsidNumber > 65535) {
                        throw new NumberFormatException();
                    }
                    if (ccsidNumber == 5026) {
                        return FormValidation.error((String)Messages.IBMiServer_ccsid_5026_not_supported());
                    }
                }
                catch (NumberFormatException e) {
                    return FormValidation.error((String)Messages.IBMiServer_invalid_ccsid());
                }
            }
            return FormValidation.ok();
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @RequirePOST
        public final FormValidation doTestConnection(@QueryParameter(required=true) String host, @QueryParameter(required=true) String credentialsId, @QueryParameter String ccsid, @QueryParameter boolean secure, @AncestorInPath Item item) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)ACL.SYSTEM2), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
            IBMiServerConfiguration config = new IBMiServerConfiguration("", host, credentialsId, ccsid, secure);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try (PrintStream stream = new PrintStream((OutputStream)output, false, StandardCharsets.UTF_8);){
                IBMi ibmi = new IBMi(stream, host, credentials, config.getCcsidInt(), secure, false);
                try {
                    FormValidation formValidation = FormValidation.ok((String)Messages.IBMiServer_ConnectionOk(host, ibmi.getOSVersion()));
                    ibmi.close();
                    return formValidation;
                }
                catch (Throwable throwable) {
                    try {
                        ibmi.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, Messages.IBMiServer_ConnectionFailed(e.getLocalizedMessage()), e);
                return FormValidation.error((Throwable)e, (String)Messages.IBMiServer_ConnectionFailed(e.getLocalizedMessage()));
            }
        }

        @NonNull
        public String getDisplayName() {
            return "";
        }
    }
}

