/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.SaveFile;
import com.ibm.as400.access.SaveFileEntry;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class SaveFileContent
implements Serializable {
    private static final long serialVersionUID = -4924933386903899243L;
    private final String name;
    private final long size;
    private final String creationLPAR;
    private final String description;
    private final List<SAVFEntry> entries = new LinkedList<SAVFEntry>();
    private final String targetRelease;
    private String savedLibrary;

    public SaveFileContent(SaveFile saveFile) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.name = saveFile.getName();
        this.description = saveFile.getDescription();
        this.size = saveFile.getLength();
        AS400 ibmi = saveFile.getSystem();
        if (saveFile.getTargetRelease().equals("*CURRENT")) {
            this.targetRelease = String.format("V%sR%sM%s", ibmi.getVersion(), ibmi.getRelease(), ibmi.getModification());
        } else if (saveFile.getTargetRelease().equals("*PRV")) {
            int version = ibmi.getVersion();
            int release = ibmi.getRelease();
            if (version == 7 && release == 1) {
                version = 6;
            } else if (version == 6) {
                version = 5;
                release = 4;
            } else {
                --release;
            }
            this.targetRelease = String.format("V%sR%sM%s", version, release, ibmi.getModification());
        } else {
            this.targetRelease = saveFile.getTargetRelease();
        }
        this.creationLPAR = saveFile.getSystem().getSystemName();
        List savfEntries = Optional.ofNullable(saveFile.listEntries()).map(Arrays::asList).orElseGet(Collections::emptyList);
        for (SaveFileEntry entry : savfEntries) {
            if (entry.getType().equalsIgnoreCase("*lib")) {
                this.savedLibrary = entry.getLibrary();
                continue;
            }
            this.entries.add(new SAVFEntry(entry));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getCreationLPAR() {
        return this.creationLPAR;
    }

    public String getSavedLibrary() {
        return this.savedLibrary;
    }

    public String getDescription() {
        return this.description;
    }

    public List<SAVFEntry> getEntries() {
        return this.entries;
    }

    public String getTargetRelease() {
        return this.targetRelease;
    }

    public long getSize() {
        return this.size;
    }

    public String toJSON() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.writeValueAsString((Object)this);
    }

    public static class SAVFEntry
    implements Serializable {
        private static final long serialVersionUID = -1097647869173691842L;
        private final String name;
        private final String description;
        private final String library;
        private final String extendedObjectAttribute;
        private final boolean dataSaved;
        private final String owner;
        private final long size;
        private final String type;

        public SAVFEntry(SaveFileEntry entry) {
            this.name = entry.getName();
            this.description = entry.getDescription();
            this.library = entry.getLibrary();
            this.extendedObjectAttribute = entry.getExtendedObjectAttribute();
            this.dataSaved = entry.isDataSaved();
            this.owner = entry.getOwner();
            this.size = entry.getSize();
            this.type = entry.getType();
        }

        public String getDescription() {
            return this.description;
        }

        public String getExtendedObjectAttribute() {
            return this.extendedObjectAttribute;
        }

        public String getLibrary() {
            return this.library;
        }

        public String getName() {
            return this.name;
        }

        public String getOwner() {
            return this.owner;
        }

        public long getSize() {
            return this.size;
        }

        public String getType() {
            return this.type;
        }

        public boolean isDataSaved() {
            return this.dataSaved;
        }
    }
}

