/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.steps;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFile;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import java.io.IOException;
import java.text.MessageFormat;
import org.jenkinsci.plugins.ibmisteps.Messages;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;
import org.jenkinsci.plugins.ibmisteps.model.LoggerWrapper;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStep;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;

public class IBMiGetIFSStep
extends IBMiStep<Void> {
    private static final long serialVersionUID = -6721839340320567902L;
    private final String from;
    private final String to;

    @DataBoundConstructor
    public IBMiGetIFSStep(String from, String to) {
        this.from = from;
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    @Override
    protected Void runOnIBMi(StepContext context, LoggerWrapper logger, IBMi ibmi) throws IOException, InterruptedException, AS400SecurityException {
        IFSFile fromIFS = new IFSFile(ibmi.getIbmiConnection(), this.from);
        if (!fromIFS.exists()) {
            throw new AbortException(Messages.IBMiGetIFSStep_from_not_found(fromIFS));
        }
        FilePath toPath = ((FilePath)context.get(FilePath.class)).child(this.to);
        if (!toPath.exists()) {
            toPath.mkdirs();
            if (!toPath.exists()) {
                throw new AbortException(Messages.IBMiGetIFSStep_failed_create_to(toPath));
            }
        } else if (!toPath.isDirectory()) {
            throw new AbortException(Messages.IBMiGetIFSStep_to_is_file(toPath));
        }
        if (fromIFS.isDirectory()) {
            logger.log(Messages.IBMiGetIFSStep_copy_folder(fromIFS, toPath));
            this.getFolder(logger, ibmi, fromIFS, toPath);
        } else if (fromIFS.isFile()) {
            logger.log(Messages.IBMiGetIFSStep_copy_file(fromIFS, toPath));
            this.getFile(logger, ibmi, fromIFS, toPath);
        }
        return null;
    }

    private void getFile(LoggerWrapper logger, IBMi ibmi, IFSFile ifsFile, FilePath folder) throws IOException, AS400SecurityException, InterruptedException {
        FilePath targetFile = folder.child(ifsFile.getName());
        if (targetFile.exists()) {
            targetFile.delete();
        }
        logger.trace(MessageFormat.format("Getting {0} into {1} ({2} bytes)", ifsFile, targetFile, ifsFile.length()));
        ibmi.download(ifsFile, targetFile);
    }

    private void getFolder(LoggerWrapper logger, IBMi ibmi, IFSFile ifsFolder, FilePath folder) throws IOException, InterruptedException, AS400SecurityException {
        ifsFolder.setPatternMatching(1);
        for (IFSFile item : ifsFolder.listFiles()) {
            if (item.isDirectory()) {
                this.getFolder(logger, ibmi, item, folder.child(item.getName()));
                continue;
            }
            if (!item.isFile()) continue;
            this.getFile(logger, ibmi, item, folder);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends IBMiStepDescriptor {
        public String getFunctionName() {
            return "ibmiGetIFS";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.IBMiGetIFSStep_description();
        }
    }
}

