/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;

public class SpooledFiles
extends ArrayList<SpooledFile> {
    private static final long serialVersionUID = 1551585884795126297L;

    public String toJSON() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.writeValueAsString((Object)this);
    }

    public static class SpooledFile
    implements Serializable {
        private static final long serialVersionUID = -4169248633194708888L;
        private final String jobName;
        private final String jobUser;
        private final String jobNumber;
        private final String name;
        private final int number;
        private final long size;
        private final String userData;
        private final String fileName;

        public SpooledFile(String name, int number, long size, String userData, String jobName, String jobUser, String jobNumber) {
            this.name = name;
            this.number = number;
            this.jobName = jobName;
            this.jobUser = jobUser;
            this.jobNumber = jobNumber;
            this.size = size;
            this.userData = userData;
            this.fileName = String.format("%s_%s.txt", name, number);
        }

        @JsonIgnore
        public boolean exists() {
            return this.size > 0L;
        }

        public String getJobName() {
            return this.jobName;
        }

        public String getJobNumber() {
            return this.jobNumber;
        }

        public String getJobUser() {
            return this.jobUser;
        }

        public String getName() {
            return this.name;
        }

        public int getNumber() {
            return this.number;
        }

        public String getUserData() {
            return this.userData;
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getSize() {
            return this.size;
        }
    }
}

