/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.configuration;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.ibmisteps.Messages;
import org.jenkinsci.plugins.ibmisteps.configuration.IBMiServerConfiguration;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class IBMiGlobalConfiguration
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(IBMiGlobalConfiguration.class.getName());
    private List<IBMiServerConfiguration> servers = Collections.emptyList();

    @DataBoundConstructor
    public IBMiGlobalConfiguration() {
        this.load();
    }

    public static IBMiGlobalConfiguration get() {
        return (IBMiGlobalConfiguration)((Object)ExtensionList.lookupSingleton(IBMiGlobalConfiguration.class));
    }

    @CheckForNull
    public IBMiServerConfiguration getServer(String name) {
        return this.servers.stream().filter(server -> server.getName().equals(name)).findFirst().orElse(null);
    }

    public List<IBMiServerConfiguration> getServers() {
        return this.servers;
    }

    public void setServers(List<IBMiServerConfiguration> servers) {
        this.servers = servers;
        this.save();
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        this.servers.clear();
        boolean configured = super.configure(req, json);
        for (IBMiServerConfiguration server : this.servers) {
            if (!this.servers.stream().anyMatch(s -> s != server && s.getName().equals(server.getName())) || !LOGGER.isLoggable(Level.WARNING)) continue;
            LOGGER.warning(Messages.IBMiGlobalConfiguration_duplicated_servers(server.getName()));
        }
        return configured;
    }
}

