/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.steps.abstracts;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.list.OpenListException;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.sql.SQLException;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;
import org.jenkinsci.plugins.ibmisteps.model.IBMiContext;
import org.jenkinsci.plugins.ibmisteps.model.LoggerWrapper;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public abstract class IBMiStep<T>
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;

    protected abstract T runOnIBMi(StepContext var1, LoggerWrapper var2, IBMi var3) throws IOException, InterruptedException, AS400SecurityException, ErrorCompletingRequestException, ObjectDoesNotExistException, SQLException, OpenListException;

    public StepExecution start(StepContext context) {
        return new SynchronousNonBlockingStepExecution<T>(context){
            private static final long serialVersionUID = 1L;
            private transient LoggerWrapper logger;

            protected T run() throws Exception {
                IBMi ibmi = ((IBMiContext)this.getContext().get(IBMiContext.class)).getIBMi((TaskListener)this.getContext().get(TaskListener.class));
                return IBMiStep.this.runOnIBMi(this.getContext(), this.getLogger(), ibmi);
            }

            private LoggerWrapper getLogger() throws IOException, InterruptedException {
                if (this.logger == null) {
                    boolean traceEnabled = ((IBMiContext)this.getContext().get(IBMiContext.class)).isTraceEnabled();
                    PrintStream printStream = ((TaskListener)this.getContext().get(TaskListener.class)).getLogger();
                    this.logger = new LoggerWrapper(printStream, traceEnabled);
                }
                return this.logger;
            }
        };
    }
}

