/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.steps;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ObjectDoesNotExistException;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.jenkinsci.plugins.ibmisteps.Messages;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;
import org.jenkinsci.plugins.ibmisteps.model.LoggerWrapper;
import org.jenkinsci.plugins.ibmisteps.model.OnMessageWait;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStep;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class IBMiWaitJobStep
extends IBMiStep<Job> {
    private static final long serialVersionUID = 6918372653694281442L;
    private final String name;
    private final String number;
    private final String user;
    private int timeout;
    private OnMessageWait onMSGW = OnMessageWait.WAIT;

    @DataBoundConstructor
    public IBMiWaitJobStep(String name, String number, String user) {
        this.name = name;
        this.number = number;
        this.user = user;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.user;
    }

    public String getNumber() {
        return this.number;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public OnMessageWait getOnMSGW() {
        return this.onMSGW;
    }

    @DataBoundSetter
    public void setOnMSGW(OnMessageWait onMSGW) {
        this.onMSGW = onMSGW;
    }

    @Override
    protected Job runOnIBMi(StepContext stepContext, LoggerWrapper logger, IBMi ibmi) throws InterruptedException, AbortException {
        Instant start = Instant.now();
        Job job = new Job(ibmi.getIbmiConnection(), this.name, this.user, this.number);
        logger.log(Messages.IBMiWaitJob_waiting(job.toString()));
        boolean timeoutReached = false;
        boolean resume = false;
        try {
            boolean wait = this.isJobRunning(job);
            while (!resume && wait && !timeoutReached) {
                boolean bl = timeoutReached = this.timeout > 0 && Duration.between(start, Instant.now()).getSeconds() > (long)this.timeout;
                if (this.isJobInMSGW(job)) {
                    resume = this.handleMessageWait(logger, job);
                } else {
                    wait = this.isJobRunning(job);
                }
                Thread.sleep(500L);
            }
        }
        catch (AbortException e) {
            throw e;
        }
        catch (AS400SecurityException | ErrorCompletingRequestException | ObjectDoesNotExistException | IOException e) {
            logger.log(Messages.IBMiWaitJob_error(e.getLocalizedMessage()));
        }
        if (timeoutReached) {
            logger.log(Messages.IBMiWaitJob_timeout_reached(this.timeout));
        } else if (!resume) {
            logger.log(Messages.IBMiWaitJob_job_ended(job.toString()));
        }
        return job;
    }

    private boolean handleMessageWait(LoggerWrapper logger, Job job) throws AS400SecurityException, ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException {
        if (this.onMSGW != OnMessageWait.FAIL) {
            logger.log(Messages.IBMiWaitJob_MSGW());
        }
        switch (this.onMSGW) {
            case KILL: {
                logger.log(Messages.IBMiWaitJob_MSGW_kill(job.toString()));
                job.end(0);
                break;
            }
            case WAIT: {
                logger.log(Messages.IBMiWaitJob_MSGW_wait(job.toString()));
                while (this.isJobInMSGW(job)) {
                    Thread.sleep(500L);
                }
                logger.log(Messages.IBMiWaitJob_MSGW_resume());
                return true;
            }
            case RESUME: {
                logger.log(Messages.IBMiWaitJob_MSGW_resume());
                return true;
            }
            case FAIL: {
                throw new AbortException(Messages.IBMiWaitJob_MSGW());
            }
        }
        return false;
    }

    private boolean isJobRunning(Job job) throws AS400SecurityException, ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException {
        try {
            job.loadInformation();
            return job.getStatus().equals("*ACTIVE");
        }
        catch (AS400Exception e) {
            this.handleJobException(e);
            return true;
        }
    }

    private boolean isJobInMSGW(Job job) throws AS400SecurityException, ObjectDoesNotExistException, IOException, InterruptedException, ErrorCompletingRequestException {
        try {
            job.loadInformation();
            return job.getValue(101).equals("MSGW");
        }
        catch (AS400Exception e) {
            this.handleJobException(e);
            return true;
        }
    }

    private void handleJobException(AS400Exception e) throws AS400Exception {
        if (!e.getAS400Message().getID().equals("CPF3C52")) {
            throw e;
        }
    }

    @Extension
    public static class DescritptorImpl
    extends IBMiStepDescriptor {
        public String getFunctionName() {
            return "ibmiWaitJob";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.IBMiWaitJob_description();
        }
    }
}

