/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.steps;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import java.io.IOException;
import org.jenkinsci.plugins.ibmisteps.Messages;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;
import org.jenkinsci.plugins.ibmisteps.model.LoggerWrapper;
import org.jenkinsci.plugins.ibmisteps.model.ShellExec;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStep;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class IBMiShellExecStep
extends IBMiStep<ShellExec> {
    private static final long serialVersionUID = 1293378013455000563L;
    private final String command;
    private boolean failOnError = true;

    @DataBoundConstructor
    public IBMiShellExecStep(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    protected ShellExec runOnIBMi(StepContext context, LoggerWrapper logger, IBMi ibmi) throws AS400SecurityException, IOException, InterruptedException, ErrorCompletingRequestException {
        logger.log(Messages.IBMiShellExecStep_running(this.command));
        ShellExec result = ibmi.executeShellCommand(this.command);
        if (result.code() == 0) {
            logger.log(Messages.IBMiShellExecStep_succeeded(this.command));
        } else {
            String error = Messages.IBMiShellExecStep_failed(this.command, result.code(), result.output());
            if (this.failOnError) {
                throw new AbortException(error);
            }
            logger.error(error);
        }
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends IBMiStepDescriptor {
        public String getFunctionName() {
            return "ibmiShellExec";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.IBMiShellExecStep_description();
        }
    }
}

