/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.steps;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFile;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.util.FormValidation;
import java.io.IOException;
import java.text.MessageFormat;
import org.jenkinsci.plugins.ibmisteps.Messages;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;
import org.jenkinsci.plugins.ibmisteps.model.LoggerWrapper;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStep;
import org.jenkinsci.plugins.ibmisteps.steps.abstracts.IBMiStepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class IBMiPutIFSStep
extends IBMiStep<Void> {
    private static final long serialVersionUID = 1011610851208715193L;
    private final String from;
    private final String to;
    private int ccsid = 1208;

    @DataBoundConstructor
    public IBMiPutIFSStep(String from, String to) {
        this.from = from;
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public int getCcsid() {
        return this.ccsid;
    }

    @DataBoundSetter
    public void setCcsid(int ccsid) {
        this.ccsid = ccsid;
    }

    @Override
    protected Void runOnIBMi(StepContext context, LoggerWrapper logger, IBMi ibmi) throws IOException, InterruptedException, AS400SecurityException {
        FilePath fromPath = ((FilePath)context.get(FilePath.class)).child(this.from);
        if (!fromPath.exists()) {
            throw new AbortException(Messages.IBMiPutIFSStep_from_not_found(fromPath));
        }
        IFSFile toFolder = new IFSFile(ibmi.getIbmiConnection(), this.to);
        if (!toFolder.exists()) {
            toFolder.mkdirs();
            if (!toFolder.exists()) {
                throw new AbortException(Messages.IBMiPutIFSStep_failed_create_to(fromPath));
            }
        } else if (toFolder.isFile()) {
            throw new AbortException(Messages.IBMiPutIFSStep_to_is_file(fromPath));
        }
        if (fromPath.isDirectory()) {
            logger.log(Messages.IBMiPutIFSStep_copy_folder(fromPath, toFolder));
            this.putFolder(logger, ibmi, fromPath, toFolder);
        } else {
            logger.log(Messages.IBMiPutIFSStep_copy_file(fromPath, toFolder));
            this.putFile(logger, ibmi, fromPath, toFolder);
        }
        return null;
    }

    private void putFile(LoggerWrapper logger, IBMi ibmi, FilePath file, IFSFile ifsFolder) throws IOException, AS400SecurityException, InterruptedException {
        IFSFile targetFile = new IFSFile(ifsFolder, file.getName());
        logger.trace(MessageFormat.format("Putting {0} into {1} ({2} bytes)", file, targetFile, file.length()));
        ibmi.upload(file, targetFile, this.ccsid);
    }

    private void putFolder(LoggerWrapper logger, IBMi ibmi, FilePath folder, IFSFile ifsFolder) throws IOException, InterruptedException, AS400SecurityException {
        for (FilePath item : folder.list()) {
            if (item.isDirectory()) {
                this.putFolder(logger, ibmi, item, new IFSFile(ifsFolder, item.getName()));
                continue;
            }
            this.putFile(logger, ibmi, item, ifsFolder);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends IBMiStepDescriptor {
        public String getFunctionName() {
            return "ibmiPutIFS";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.IBMiPutIFSStep_description();
        }

        @RequirePOST
        public FormValidation doCheckCcsid(@QueryParameter Integer ccsid) {
            if (ccsid != null) {
                try {
                    if (ccsid < 1 || ccsid > 65535) {
                        throw new NumberFormatException();
                    }
                    if (ccsid == 5026) {
                        return FormValidation.error((String)Messages.IBMiServer_ccsid_5026_not_supported());
                    }
                }
                catch (NumberFormatException e) {
                    return FormValidation.error((String)Messages.IBMiServer_invalid_ccsid());
                }
            }
            return FormValidation.ok();
        }
    }
}

