/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.model;

import java.io.PrintStream;
import java.util.Objects;

public class LoggerWrapper {
    private final PrintStream logger;
    private final boolean doTrace;

    public LoggerWrapper(PrintStream logger, boolean doTrace) {
        this.logger = Objects.requireNonNull(logger, "Logger cannot be null");
        this.doTrace = doTrace;
    }

    public synchronized void log(String format, Object ... args) {
        this.logger.println("[INFO] " + String.format(format, args));
    }

    public synchronized void log(String message) {
        this.logger.println("[INFO] " + message);
    }

    public synchronized void error(String format, Object ... args) {
        this.logger.println("[ERROR] " + String.format(format, args));
    }

    public synchronized void error(String message) {
        this.logger.println("[ERROR] " + message);
    }

    public synchronized void trace(String format, Object ... args) {
        if (this.doTrace) {
            this.logger.println("[TRACE] " + String.format(format, args));
        }
    }

    public synchronized void trace(String message) {
        if (this.doTrace) {
            this.logger.println("[TRACE] " + message);
        }
    }
}

