// CHECKSTYLE:OFF

package org.jenkinsci.plugins.ibmisteps;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code IBMiRunSQLStep.failed}: {@code SQL execution failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code SQL execution failed: {0}}
     */
    public static String IBMiRunSQLStep_failed(Object arg0) {
        return holder.format("IBMiRunSQLStep.failed", arg0);
    }

    /**
     * Key {@code IBMiRunSQLStep.failed}: {@code SQL execution failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code SQL execution failed: {0}}
     */
    public static Localizable _IBMiRunSQLStep_failed(Object arg0) {
        return new Localizable(holder, "IBMiRunSQLStep.failed", arg0);
    }

    /**
     * Key {@code IBMiPutIFSStep.to.is.file}: {@code {0} is an IFS file}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is an IFS file}
     */
    public static String IBMiPutIFSStep_to_is_file(Object arg0) {
        return holder.format("IBMiPutIFSStep.to.is.file", arg0);
    }

    /**
     * Key {@code IBMiPutIFSStep.to.is.file}: {@code {0} is an IFS file}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is an IFS file}
     */
    public static Localizable _IBMiPutIFSStep_to_is_file(Object arg0) {
        return new Localizable(holder, "IBMiPutIFSStep.to.is.file", arg0);
    }

    /**
     * Key {@code IBMiGetIFSStep.failed.create.to}: {@code Failed to create
     * local folder {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to create local folder {0}}
     */
    public static String IBMiGetIFSStep_failed_create_to(Object arg0) {
        return holder.format("IBMiGetIFSStep.failed.create.to", arg0);
    }

    /**
     * Key {@code IBMiGetIFSStep.failed.create.to}: {@code Failed to create
     * local folder {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to create local folder {0}}
     */
    public static Localizable _IBMiGetIFSStep_failed_create_to(Object arg0) {
        return new Localizable(holder, "IBMiGetIFSStep.failed.create.to", arg0);
    }

    /**
     * Key {@code IBMiWaitJob.waiting}: {@code Waiting for IBM i job {0} to
     * end}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Waiting for IBM i job {0} to end}
     */
    public static String IBMiWaitJob_waiting(Object arg0) {
        return holder.format("IBMiWaitJob.waiting", arg0);
    }

    /**
     * Key {@code IBMiWaitJob.waiting}: {@code Waiting for IBM i job {0} to
     * end}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Waiting for IBM i job {0} to end}
     */
    public static Localizable _IBMiWaitJob_waiting(Object arg0) {
        return new Localizable(holder, "IBMiWaitJob.waiting", arg0);
    }

    /**
     * Key {@code IBMiWaitJob.timeout.reached}: {@code Timeout has been
     * reached ({0} second(s))}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Timeout has been reached ({0} second(s))}
     */
    public static String IBMiWaitJob_timeout_reached(Object arg0) {
        return holder.format("IBMiWaitJob.timeout.reached", arg0);
    }

    /**
     * Key {@code IBMiWaitJob.timeout.reached}: {@code Timeout has been
     * reached ({0} second(s))}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Timeout has been reached ({0} second(s))}
     */
    public static Localizable _IBMiWaitJob_timeout_reached(Object arg0) {
        return new Localizable(holder, "IBMiWaitJob.timeout.reached", arg0);
    }

    /**
     * Key {@code IBMiServer.ConnectionOk}: {@code Connection to {0} (IBM i
     * OS {1}) OK}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection to {0} (IBM i OS {1}) OK}
     */
    public static String IBMiServer_ConnectionOk(Object arg0, Object arg1) {
        return holder.format("IBMiServer.ConnectionOk", arg0, arg1);
    }

    /**
     * Key {@code IBMiServer.ConnectionOk}: {@code Connection to {0} (IBM i
     * OS {1}) OK}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection to {0} (IBM i OS {1}) OK}
     */
    public static Localizable _IBMiServer_ConnectionOk(Object arg0, Object arg1) {
        return new Localizable(holder, "IBMiServer.ConnectionOk", arg0, arg1);
    }

    /**
     * Key {@code IBMiWaitJob.MSGW.kill}: {@code Killing job {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Killing job {0}}
     */
    public static String IBMiWaitJob_MSGW_kill(Object arg0) {
        return holder.format("IBMiWaitJob.MSGW.kill", arg0);
    }

    /**
     * Key {@code IBMiWaitJob.MSGW.kill}: {@code Killing job {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Killing job {0}}
     */
    public static Localizable _IBMiWaitJob_MSGW_kill(Object arg0) {
        return new Localizable(holder, "IBMiWaitJob.MSGW.kill", arg0);
    }

    /**
     * Key {@code IBMiServer.ccsid.5026.not.supported}: {@code CCSID 5026 is
     * not supported; use 5035 instead}.
     * 
     * @return
     *     {@code CCSID 5026 is not supported; use 5035 instead}
     */
    public static String IBMiServer_ccsid_5026_not_supported() {
        return holder.format("IBMiServer.ccsid.5026.not.supported");
    }

    /**
     * Key {@code IBMiServer.ccsid.5026.not.supported}: {@code CCSID 5026 is
     * not supported; use 5035 instead}.
     * 
     * @return
     *     {@code CCSID 5026 is not supported; use 5035 instead}
     */
    public static Localizable _IBMiServer_ccsid_5026_not_supported() {
        return new Localizable(holder, "IBMiServer.ccsid.5026.not.supported");
    }

    /**
     * Key {@code IBMiGetIFSStep.to.is.file}: {@code {0} is a file}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is a file}
     */
    public static String IBMiGetIFSStep_to_is_file(Object arg0) {
        return holder.format("IBMiGetIFSStep.to.is.file", arg0);
    }

    /**
     * Key {@code IBMiGetIFSStep.to.is.file}: {@code {0} is a file}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is a file}
     */
    public static Localizable _IBMiGetIFSStep_to_is_file(Object arg0) {
        return new Localizable(holder, "IBMiGetIFSStep.to.is.file", arg0);
    }

    /**
     * Key {@code IBMi.failed.sql.service.check}: {@code Failed to check SQL
     * Service: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to check SQL Service: {0}}
     */
    public static String IBMi_failed_sql_service_check(Object arg0) {
        return holder.format("IBMi.failed.sql.service.check", arg0);
    }

    /**
     * Key {@code IBMi.failed.sql.service.check}: {@code Failed to check SQL
     * Service: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to check SQL Service: {0}}
     */
    public static Localizable _IBMi_failed_sql_service_check(Object arg0) {
        return new Localizable(holder, "IBMi.failed.sql.service.check", arg0);
    }

    /**
     * Key {@code IBMiDownloadSAVF.save.file.not.found}: {@code Save File
     * {0}/{1} not found}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Save File {0}/{1} not found}
     */
    public static String IBMiDownloadSAVF_save_file_not_found(Object arg0, Object arg1) {
        return holder.format("IBMiDownloadSAVF.save.file.not.found", arg0, arg1);
    }

    /**
     * Key {@code IBMiDownloadSAVF.save.file.not.found}: {@code Save File
     * {0}/{1} not found}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Save File {0}/{1} not found}
     */
    public static Localizable _IBMiDownloadSAVF_save_file_not_found(Object arg0, Object arg1) {
        return new Localizable(holder, "IBMiDownloadSAVF.save.file.not.found", arg0, arg1);
    }

    /**
     * Key {@code IBMiWaitJob.description}: {@code Wait for an IBM i to end}.
     * 
     * @return
     *     {@code Wait for an IBM i to end}
     */
    public static String IBMiWaitJob_description() {
        return holder.format("IBMiWaitJob.description");
    }

    /**
     * Key {@code IBMiWaitJob.description}: {@code Wait for an IBM i to end}.
     * 
     * @return
     *     {@code Wait for an IBM i to end}
     */
    public static Localizable _IBMiWaitJob_description() {
        return new Localizable(holder, "IBMiWaitJob.description");
    }

    /**
     * Key {@code IBMi.closeSQL.error}: {@code Error occurred while closing
     * SQL connection: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Error occurred while closing SQL connection: {0}}
     */
    public static String IBMi_closeSQL_error(Object arg0) {
        return holder.format("IBMi.closeSQL.error", arg0);
    }

    /**
     * Key {@code IBMi.closeSQL.error}: {@code Error occurred while closing
     * SQL connection: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Error occurred while closing SQL connection: {0}}
     */
    public static Localizable _IBMi_closeSQL_error(Object arg0) {
        return new Localizable(holder, "IBMi.closeSQL.error", arg0);
    }

    /**
     * Key {@code IBMiGetIFSStep.description}: {@code Download a remote IFS
     * file or folder into local workspace folder}.
     * 
     * @return
     *     {@code Download a remote IFS file or folder into local workspace
     *     folder}
     */
    public static String IBMiGetIFSStep_description() {
        return holder.format("IBMiGetIFSStep.description");
    }

    /**
     * Key {@code IBMiGetIFSStep.description}: {@code Download a remote IFS
     * file or folder into local workspace folder}.
     * 
     * @return
     *     {@code Download a remote IFS file or folder into local workspace
     *     folder}
     */
    public static Localizable _IBMiGetIFSStep_description() {
        return new Localizable(holder, "IBMiGetIFSStep.description");
    }

    /**
     * Key {@code IBMICommandStep.failed.with.message}: {@code IBM i command
     * {0} failed: [{1}] {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code IBM i command {0} failed: [{1}] {2}}
     */
    public static String IBMICommandStep_failed_with_message(Object arg0, Object arg1, Object arg2) {
        return holder.format("IBMICommandStep.failed.with.message", arg0, arg1, arg2);
    }

    /**
     * Key {@code IBMICommandStep.failed.with.message}: {@code IBM i command
     * {0} failed: [{1}] {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code IBM i command {0} failed: [{1}] {2}}
     */
    public static Localizable _IBMICommandStep_failed_with_message(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "IBMICommandStep.failed.with.message", arg0, arg1, arg2);
    }

    /**
     * Key {@code IBMiGetSpooledFiles.getting}: {@code Getting spooled files
     * of job {0}/{1}/{2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Getting spooled files of job {0}/{1}/{2}}
     */
    public static String IBMiGetSpooledFiles_getting(Object arg0, Object arg1, Object arg2) {
        return holder.format("IBMiGetSpooledFiles.getting", arg0, arg1, arg2);
    }

    /**
     * Key {@code IBMiGetSpooledFiles.getting}: {@code Getting spooled files
     * of job {0}/{1}/{2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Getting spooled files of job {0}/{1}/{2}}
     */
    public static Localizable _IBMiGetSpooledFiles_getting(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "IBMiGetSpooledFiles.getting", arg0, arg1, arg2);
    }

    /**
     * Key {@code OnIBMiStep.localhost}: {@code Local IBM i (only when using
     * an agent running on IBM i)}.
     * 
     * @return
     *     {@code Local IBM i (only when using an agent running on IBM i)}
     */
    public static String OnIBMiStep_localhost() {
        return holder.format("OnIBMiStep.localhost");
    }

    /**
     * Key {@code OnIBMiStep.localhost}: {@code Local IBM i (only when using
     * an agent running on IBM i)}.
     * 
     * @return
     *     {@code Local IBM i (only when using an agent running on IBM i)}
     */
    public static Localizable _OnIBMiStep_localhost() {
        return new Localizable(holder, "OnIBMiStep.localhost");
    }

    /**
     * Key {@code IBMi.connected}: {@code Connected {4} to {0} (IBM i OS {1})
     * with profile {2} and CCSID {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connected {4} to {0} (IBM i OS {1}) with profile {2} and CCSID
     *     {3}}
     */
    public static String IBMi_connected(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return holder.format("IBMi.connected", arg0, arg1, arg2, arg3, arg4);
    }

    /**
     * Key {@code IBMi.connected}: {@code Connected {4} to {0} (IBM i OS {1})
     * with profile {2} and CCSID {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connected {4} to {0} (IBM i OS {1}) with profile {2} and CCSID
     *     {3}}
     */
    public static Localizable _IBMi_connected(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return new Localizable(holder, "IBMi.connected", arg0, arg1, arg2, arg3, arg4);
    }

    /**
     * Key {@code IBMiRunSQLStep.running}: {@code Running SQL query {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Running SQL query {0}}
     */
    public static String IBMiRunSQLStep_running(Object arg0) {
        return holder.format("IBMiRunSQLStep.running", arg0);
    }

    /**
     * Key {@code IBMiRunSQLStep.running}: {@code Running SQL query {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Running SQL query {0}}
     */
    public static Localizable _IBMiRunSQLStep_running(Object arg0) {
        return new Localizable(holder, "IBMiRunSQLStep.running", arg0);
    }

    /**
     * Key {@code IBMi.connect.remote}: {@code Connecting to {1}@{0}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connecting to {1}@{0}}
     */
    public static String IBMi_connect_remote(Object arg0, Object arg1) {
        return holder.format("IBMi.connect.remote", arg0, arg1);
    }

    /**
     * Key {@code IBMi.connect.remote}: {@code Connecting to {1}@{0}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connecting to {1}@{0}}
     */
    public static Localizable _IBMi_connect_remote(Object arg0, Object arg1) {
        return new Localizable(holder, "IBMi.connect.remote", arg0, arg1);
    }

    /**
     * Key {@code IBMICommandStep.succeeded}: {@code IBM i command {0}
     * succeeded}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code IBM i command {0} succeeded}
     */
    public static String IBMICommandStep_succeeded(Object arg0) {
        return holder.format("IBMICommandStep.succeeded", arg0);
    }

    /**
     * Key {@code IBMICommandStep.succeeded}: {@code IBM i command {0}
     * succeeded}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code IBM i command {0} succeeded}
     */
    public static Localizable _IBMICommandStep_succeeded(Object arg0) {
        return new Localizable(holder, "IBMICommandStep.succeeded", arg0);
    }

    /**
     * Key {@code IBMiWaitJob.job.ended}: {@code IBM i job {0} has ended}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code IBM i job {0} has ended}
     */
    public static String IBMiWaitJob_job_ended(Object arg0) {
        return holder.format("IBMiWaitJob.job.ended", arg0);
    }

    /**
     * Key {@code IBMiWaitJob.job.ended}: {@code IBM i job {0} has ended}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code IBM i job {0} has ended}
     */
    public static Localizable _IBMiWaitJob_job_ended(Object arg0) {
        return new Localizable(holder, "IBMiWaitJob.job.ended", arg0);
    }

    /**
     * Key {@code IBMiUploadSAVF.workspace.file.not.found}: {@code Workspace
     * file {0} not found}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Workspace file {0} not found}
     */
    public static String IBMiUploadSAVF_workspace_file_not_found(Object arg0) {
        return holder.format("IBMiUploadSAVF.workspace.file.not.found", arg0);
    }

    /**
     * Key {@code IBMiUploadSAVF.workspace.file.not.found}: {@code Workspace
     * file {0} not found}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Workspace file {0} not found}
     */
    public static Localizable _IBMiUploadSAVF_workspace_file_not_found(Object arg0) {
        return new Localizable(holder, "IBMiUploadSAVF.workspace.file.not.found", arg0);
    }

    /**
     * Key {@code OnMessageWait.fail}: {@code Fail pipeline}.
     * 
     * @return
     *     {@code Fail pipeline}
     */
    public static String OnMessageWait_fail() {
        return holder.format("OnMessageWait.fail");
    }

    /**
     * Key {@code OnMessageWait.fail}: {@code Fail pipeline}.
     * 
     * @return
     *     {@code Fail pipeline}
     */
    public static Localizable _OnMessageWait_fail() {
        return new Localizable(holder, "OnMessageWait.fail");
    }

    /**
     * Key {@code IBMiPutIFSStep.description}: {@code Upload a local
     * workspace file or folder into a remote IFS folder}.
     * 
     * @return
     *     {@code Upload a local workspace file or folder into a remote IFS
     *     folder}
     */
    public static String IBMiPutIFSStep_description() {
        return holder.format("IBMiPutIFSStep.description");
    }

    /**
     * Key {@code IBMiPutIFSStep.description}: {@code Upload a local
     * workspace file or folder into a remote IFS folder}.
     * 
     * @return
     *     {@code Upload a local workspace file or folder into a remote IFS
     *     folder}
     */
    public static Localizable _IBMiPutIFSStep_description() {
        return new Localizable(holder, "IBMiPutIFSStep.description");
    }

    /**
     * Key {@code IBMiWaitJob.MSGW.resume}: {@code Resuming pipeline
     * execution}.
     * 
     * @return
     *     {@code Resuming pipeline execution}
     */
    public static String IBMiWaitJob_MSGW_resume() {
        return holder.format("IBMiWaitJob.MSGW.resume");
    }

    /**
     * Key {@code IBMiWaitJob.MSGW.resume}: {@code Resuming pipeline
     * execution}.
     * 
     * @return
     *     {@code Resuming pipeline execution}
     */
    public static Localizable _IBMiWaitJob_MSGW_resume() {
        return new Localizable(holder, "IBMiWaitJob.MSGW.resume");
    }

    /**
     * Key {@code server.not.found}: {@code IBM i server configuration {0}
     * not found}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code IBM i server configuration {0} not found}
     */
    public static String server_not_found(Object arg0) {
        return holder.format("server.not.found", arg0);
    }

    /**
     * Key {@code server.not.found}: {@code IBM i server configuration {0}
     * not found}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code IBM i server configuration {0} not found}
     */
    public static Localizable _server_not_found(Object arg0) {
        return new Localizable(holder, "server.not.found", arg0);
    }

    /**
     * Key {@code IBMiWaitJob.error}: {@code Exception occurred while
     * retrieving job status: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception occurred while retrieving job status: {0}}
     */
    public static String IBMiWaitJob_error(Object arg0) {
        return holder.format("IBMiWaitJob.error", arg0);
    }

    /**
     * Key {@code IBMiWaitJob.error}: {@code Exception occurred while
     * retrieving job status: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception occurred while retrieving job status: {0}}
     */
    public static Localizable _IBMiWaitJob_error(Object arg0) {
        return new Localizable(holder, "IBMiWaitJob.error", arg0);
    }

    /**
     * Key {@code IBMiServer.ConnectionFailed}: {@code Connection Failed:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection Failed: {0}}
     */
    public static String IBMiServer_ConnectionFailed(Object arg0) {
        return holder.format("IBMiServer.ConnectionFailed", arg0);
    }

    /**
     * Key {@code IBMiServer.ConnectionFailed}: {@code Connection Failed:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection Failed: {0}}
     */
    public static Localizable _IBMiServer_ConnectionFailed(Object arg0) {
        return new Localizable(holder, "IBMiServer.ConnectionFailed", arg0);
    }

    /**
     * Key {@code IBMiRunSQLStep.description}: {@code Run an SQL query on Db2
     * for i}.
     * 
     * @return
     *     {@code Run an SQL query on Db2 for i}
     */
    public static String IBMiRunSQLStep_description() {
        return holder.format("IBMiRunSQLStep.description");
    }

    /**
     * Key {@code IBMiRunSQLStep.description}: {@code Run an SQL query on Db2
     * for i}.
     * 
     * @return
     *     {@code Run an SQL query on Db2 for i}
     */
    public static Localizable _IBMiRunSQLStep_description() {
        return new Localizable(holder, "IBMiRunSQLStep.description");
    }

    /**
     * Key {@code IBMiPutIFSStep.from.not.found}: {@code Local file/folder
     * {0} not found}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Local file/folder {0} not found}
     */
    public static String IBMiPutIFSStep_from_not_found(Object arg0) {
        return holder.format("IBMiPutIFSStep.from.not.found", arg0);
    }

    /**
     * Key {@code IBMiPutIFSStep.from.not.found}: {@code Local file/folder
     * {0} not found}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Local file/folder {0} not found}
     */
    public static Localizable _IBMiPutIFSStep_from_not_found(Object arg0) {
        return new Localizable(holder, "IBMiPutIFSStep.from.not.found", arg0);
    }

    /**
     * Key {@code IBMiGetSpooledFiles.cpysplf.failed}: {@code CPYSPLF call
     * failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code CPYSPLF call failed: {0}}
     */
    public static String IBMiGetSpooledFiles_cpysplf_failed(Object arg0) {
        return holder.format("IBMiGetSpooledFiles.cpysplf.failed", arg0);
    }

    /**
     * Key {@code IBMiGetSpooledFiles.cpysplf.failed}: {@code CPYSPLF call
     * failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code CPYSPLF call failed: {0}}
     */
    public static Localizable _IBMiGetSpooledFiles_cpysplf_failed(Object arg0) {
        return new Localizable(holder, "IBMiGetSpooledFiles.cpysplf.failed", arg0);
    }

    /**
     * Key {@code IBMi.connect.ccsid.5026}: {@code CCSID 5026 is not
     * supported; switching to 5035}.
     * 
     * @return
     *     {@code CCSID 5026 is not supported; switching to 5035}
     */
    public static String IBMi_connect_ccsid_5026() {
        return holder.format("IBMi.connect.ccsid.5026");
    }

    /**
     * Key {@code IBMi.connect.ccsid.5026}: {@code CCSID 5026 is not
     * supported; switching to 5035}.
     * 
     * @return
     *     {@code CCSID 5026 is not supported; switching to 5035}
     */
    public static Localizable _IBMi_connect_ccsid_5026() {
        return new Localizable(holder, "IBMi.connect.ccsid.5026");
    }

    /**
     * Key {@code IBMiGetSpooledFiles.description}: {@code Download spooled
     * files of a given job to a local workspace folder}.
     * 
     * @return
     *     {@code Download spooled files of a given job to a local workspace
     *     folder}
     */
    public static String IBMiGetSpooledFiles_description() {
        return holder.format("IBMiGetSpooledFiles.description");
    }

    /**
     * Key {@code IBMiGetSpooledFiles.description}: {@code Download spooled
     * files of a given job to a local workspace folder}.
     * 
     * @return
     *     {@code Download spooled files of a given job to a local workspace
     *     folder}
     */
    public static Localizable _IBMiGetSpooledFiles_description() {
        return new Localizable(holder, "IBMiGetSpooledFiles.description");
    }

    /**
     * Key {@code IBMiGetSpooledFiles.cpy.failed}: {@code CPY call failed:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code CPY call failed: {0}}
     */
    public static String IBMiGetSpooledFiles_cpy_failed(Object arg0) {
        return holder.format("IBMiGetSpooledFiles.cpy.failed", arg0);
    }

    /**
     * Key {@code IBMiGetSpooledFiles.cpy.failed}: {@code CPY call failed:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code CPY call failed: {0}}
     */
    public static Localizable _IBMiGetSpooledFiles_cpy_failed(Object arg0) {
        return new Localizable(holder, "IBMiGetSpooledFiles.cpy.failed", arg0);
    }

    /**
     * Key {@code OnIBMiStep.description}: {@code Provides an IBM i execution
     * environment to run IBM i steps}.
     * 
     * @return
     *     {@code Provides an IBM i execution environment to run IBM i steps}
     */
    public static String OnIBMiStep_description() {
        return holder.format("OnIBMiStep.description");
    }

    /**
     * Key {@code OnIBMiStep.description}: {@code Provides an IBM i execution
     * environment to run IBM i steps}.
     * 
     * @return
     *     {@code Provides an IBM i execution environment to run IBM i steps}
     */
    public static Localizable _OnIBMiStep_description() {
        return new Localizable(holder, "OnIBMiStep.description");
    }

    /**
     * Key {@code IBMiGetIFSStep.copy.file}: {@code Getting IFS file {0} into
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Getting IFS file {0} into {1}}
     */
    public static String IBMiGetIFSStep_copy_file(Object arg0, Object arg1) {
        return holder.format("IBMiGetIFSStep.copy.file", arg0, arg1);
    }

    /**
     * Key {@code IBMiGetIFSStep.copy.file}: {@code Getting IFS file {0} into
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Getting IFS file {0} into {1}}
     */
    public static Localizable _IBMiGetIFSStep_copy_file(Object arg0, Object arg1) {
        return new Localizable(holder, "IBMiGetIFSStep.copy.file", arg0, arg1);
    }

    /**
     * Key {@code IBMiPutIFSStep.copy.folder}: {@code Putting folder {0} into
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Putting folder {0} into {1}}
     */
    public static String IBMiPutIFSStep_copy_folder(Object arg0, Object arg1) {
        return holder.format("IBMiPutIFSStep.copy.folder", arg0, arg1);
    }

    /**
     * Key {@code IBMiPutIFSStep.copy.folder}: {@code Putting folder {0} into
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Putting folder {0} into {1}}
     */
    public static Localizable _IBMiPutIFSStep_copy_folder(Object arg0, Object arg1) {
        return new Localizable(holder, "IBMiPutIFSStep.copy.folder", arg0, arg1);
    }

    /**
     * Key {@code IBMiUploadSAVF.description}: {@code Upload a stream file
     * restore its Save File object}.
     * 
     * @return
     *     {@code Upload a stream file restore its Save File object}
     */
    public static String IBMiUploadSAVF_description() {
        return holder.format("IBMiUploadSAVF.description");
    }

    /**
     * Key {@code IBMiUploadSAVF.description}: {@code Upload a stream file
     * restore its Save File object}.
     * 
     * @return
     *     {@code Upload a stream file restore its Save File object}
     */
    public static Localizable _IBMiUploadSAVF_description() {
        return new Localizable(holder, "IBMiUploadSAVF.description");
    }

    /**
     * Key {@code IBMi.connect.invalid.ccsid}: {@code Invalid CCSID {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid CCSID {0}}
     */
    public static String IBMi_connect_invalid_ccsid(Object arg0) {
        return holder.format("IBMi.connect.invalid.ccsid", arg0);
    }

    /**
     * Key {@code IBMi.connect.invalid.ccsid}: {@code Invalid CCSID {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid CCSID {0}}
     */
    public static Localizable _IBMi_connect_invalid_ccsid(Object arg0) {
        return new Localizable(holder, "IBMi.connect.invalid.ccsid", arg0);
    }

    /**
     * Key {@code OnMessageWait.resume}: {@code Resume pipeline}.
     * 
     * @return
     *     {@code Resume pipeline}
     */
    public static String OnMessageWait_resume() {
        return holder.format("OnMessageWait.resume");
    }

    /**
     * Key {@code OnMessageWait.resume}: {@code Resume pipeline}.
     * 
     * @return
     *     {@code Resume pipeline}
     */
    public static Localizable _OnMessageWait_resume() {
        return new Localizable(holder, "OnMessageWait.resume");
    }

    /**
     * Key {@code IBMiUploadSAVF.uploading}: {@code Uploading Save File {0}
     * into {1}/{2} ({3} bytes)}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Uploading Save File {0} into {1}/{2} ({3} bytes)}
     */
    public static String IBMiUploadSAVF_uploading(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("IBMiUploadSAVF.uploading", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code IBMiUploadSAVF.uploading}: {@code Uploading Save File {0}
     * into {1}/{2} ({3} bytes)}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Uploading Save File {0} into {1}/{2} ({3} bytes)}
     */
    public static Localizable _IBMiUploadSAVF_uploading(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "IBMiUploadSAVF.uploading", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code OnMessageWait.wait}: {@code Wait until Job resumes or is
     * killed}.
     * 
     * @return
     *     {@code Wait until Job resumes or is killed}
     */
    public static String OnMessageWait_wait() {
        return holder.format("OnMessageWait.wait");
    }

    /**
     * Key {@code OnMessageWait.wait}: {@code Wait until Job resumes or is
     * killed}.
     * 
     * @return
     *     {@code Wait until Job resumes or is killed}
     */
    public static Localizable _OnMessageWait_wait() {
        return new Localizable(holder, "OnMessageWait.wait");
    }

    /**
     * Key {@code IBMi.connection.failed}: {@code Failed to connect to IBM i:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to connect to IBM i: {0}}
     */
    public static String IBMi_connection_failed(Object arg0) {
        return holder.format("IBMi.connection.failed", arg0);
    }

    /**
     * Key {@code IBMi.connection.failed}: {@code Failed to connect to IBM i:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to connect to IBM i: {0}}
     */
    public static Localizable _IBMi_connection_failed(Object arg0) {
        return new Localizable(holder, "IBMi.connection.failed", arg0);
    }

    /**
     * Key {@code IBMi.change.iasp.failed}: {@code Failed to change current
     * iASP to {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to change current iASP to {0}}
     */
    public static String IBMi_change_iasp_failed(Object arg0) {
        return holder.format("IBMi.change.iasp.failed", arg0);
    }

    /**
     * Key {@code IBMi.change.iasp.failed}: {@code Failed to change current
     * iASP to {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to change current iASP to {0}}
     */
    public static Localizable _IBMi_change_iasp_failed(Object arg0) {
        return new Localizable(holder, "IBMi.change.iasp.failed", arg0);
    }

    /**
     * Key {@code IBMiServer.invalid.ccsid}: {@code CCSID must be a number
     * between 0 and 65535}.
     * 
     * @return
     *     {@code CCSID must be a number between 0 and 65535}
     */
    public static String IBMiServer_invalid_ccsid() {
        return holder.format("IBMiServer.invalid.ccsid");
    }

    /**
     * Key {@code IBMiServer.invalid.ccsid}: {@code CCSID must be a number
     * between 0 and 65535}.
     * 
     * @return
     *     {@code CCSID must be a number between 0 and 65535}
     */
    public static Localizable _IBMiServer_invalid_ccsid() {
        return new Localizable(holder, "IBMiServer.invalid.ccsid");
    }

    /**
     * Key {@code IBMiGetIFSStep.copy.folder}: {@code Getting IFS folder {0}
     * into {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Getting IFS folder {0} into {1}}
     */
    public static String IBMiGetIFSStep_copy_folder(Object arg0, Object arg1) {
        return holder.format("IBMiGetIFSStep.copy.folder", arg0, arg1);
    }

    /**
     * Key {@code IBMiGetIFSStep.copy.folder}: {@code Getting IFS folder {0}
     * into {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Getting IFS folder {0} into {1}}
     */
    public static Localizable _IBMiGetIFSStep_copy_folder(Object arg0, Object arg1) {
        return new Localizable(holder, "IBMiGetIFSStep.copy.folder", arg0, arg1);
    }

    /**
     * Key {@code IBMiServer.credentials.required}: {@code Credentials are
     * required}.
     * 
     * @return
     *     {@code Credentials are required}
     */
    public static String IBMiServer_credentials_required() {
        return holder.format("IBMiServer.credentials.required");
    }

    /**
     * Key {@code IBMiServer.credentials.required}: {@code Credentials are
     * required}.
     * 
     * @return
     *     {@code Credentials are required}
     */
    public static Localizable _IBMiServer_credentials_required() {
        return new Localizable(holder, "IBMiServer.credentials.required");
    }

    /**
     * Key {@code IBMiRunSQLStep.rows}: {@code Query returned {0} row(s)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Query returned {0} row(s)}
     */
    public static String IBMiRunSQLStep_rows(Object arg0) {
        return holder.format("IBMiRunSQLStep.rows", arg0);
    }

    /**
     * Key {@code IBMiRunSQLStep.rows}: {@code Query returned {0} row(s)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Query returned {0} row(s)}
     */
    public static Localizable _IBMiRunSQLStep_rows(Object arg0) {
        return new Localizable(holder, "IBMiRunSQLStep.rows", arg0);
    }

    /**
     * Key {@code IBMi.connect.local}: {@code Connecting to local IBM i}.
     * 
     * @return
     *     {@code Connecting to local IBM i}
     */
    public static String IBMi_connect_local() {
        return holder.format("IBMi.connect.local");
    }

    /**
     * Key {@code IBMi.connect.local}: {@code Connecting to local IBM i}.
     * 
     * @return
     *     {@code Connecting to local IBM i}
     */
    public static Localizable _IBMi_connect_local() {
        return new Localizable(holder, "IBMi.connect.local");
    }

    /**
     * Key {@code OnMessageWait.kill}: {@code Kill Job}.
     * 
     * @return
     *     {@code Kill Job}
     */
    public static String OnMessageWait_kill() {
        return holder.format("OnMessageWait.kill");
    }

    /**
     * Key {@code OnMessageWait.kill}: {@code Kill Job}.
     * 
     * @return
     *     {@code Kill Job}
     */
    public static Localizable _OnMessageWait_kill() {
        return new Localizable(holder, "OnMessageWait.kill");
    }

    /**
     * Key {@code IBMiGetIFSStep.from.not.found}: {@code IFS File/folder {0}
     * not found}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code IFS File/folder {0} not found}
     */
    public static String IBMiGetIFSStep_from_not_found(Object arg0) {
        return holder.format("IBMiGetIFSStep.from.not.found", arg0);
    }

    /**
     * Key {@code IBMiGetIFSStep.from.not.found}: {@code IFS File/folder {0}
     * not found}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code IFS File/folder {0} not found}
     */
    public static Localizable _IBMiGetIFSStep_from_not_found(Object arg0) {
        return new Localizable(holder, "IBMiGetIFSStep.from.not.found", arg0);
    }

    /**
     * Key {@code IBMiUploadSAVF.CPYFRMSTMF.failed}: {@code Failed to copy
     * stream file {0} into {1}/{2}
     * {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to copy stream file {0} into {1}/{2}
     *     {3}}
     */
    public static String IBMiUploadSAVF_CPYFRMSTMF_failed(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("IBMiUploadSAVF.CPYFRMSTMF.failed", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code IBMiUploadSAVF.CPYFRMSTMF.failed}: {@code Failed to copy
     * stream file {0} into {1}/{2}
     * {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to copy stream file {0} into {1}/{2}
     *     {3}}
     */
    public static Localizable _IBMiUploadSAVF_CPYFRMSTMF_failed(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "IBMiUploadSAVF.CPYFRMSTMF.failed", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code IBMICommandStep.running}: {@code Running IBM i command
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Running IBM i command {0}}
     */
    public static String IBMICommandStep_running(Object arg0) {
        return holder.format("IBMICommandStep.running", arg0);
    }

    /**
     * Key {@code IBMICommandStep.running}: {@code Running IBM i command
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Running IBM i command {0}}
     */
    public static Localizable _IBMICommandStep_running(Object arg0) {
        return new Localizable(holder, "IBMICommandStep.running", arg0);
    }

    /**
     * Key {@code IBMiWaitJob.MSGW}: {@code Job is in MSGW status}.
     * 
     * @return
     *     {@code Job is in MSGW status}
     */
    public static String IBMiWaitJob_MSGW() {
        return holder.format("IBMiWaitJob.MSGW");
    }

    /**
     * Key {@code IBMiWaitJob.MSGW}: {@code Job is in MSGW status}.
     * 
     * @return
     *     {@code Job is in MSGW status}
     */
    public static Localizable _IBMiWaitJob_MSGW() {
        return new Localizable(holder, "IBMiWaitJob.MSGW");
    }

    /**
     * Key {@code IBMiWaitJob.MSGW.wait}: {@code Pipeline will be suspended
     * until Job {0} resumes}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Pipeline will be suspended until Job {0} resumes}
     */
    public static String IBMiWaitJob_MSGW_wait(Object arg0) {
        return holder.format("IBMiWaitJob.MSGW.wait", arg0);
    }

    /**
     * Key {@code IBMiWaitJob.MSGW.wait}: {@code Pipeline will be suspended
     * until Job {0} resumes}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Pipeline will be suspended until Job {0} resumes}
     */
    public static Localizable _IBMiWaitJob_MSGW_wait(Object arg0) {
        return new Localizable(holder, "IBMiWaitJob.MSGW.wait", arg0);
    }

    /**
     * Key {@code IBMiGetSpooledFiles.count}: {@code {0} spooled file(s)
     * retrieved in {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} spooled file(s) retrieved in {1}}
     */
    public static String IBMiGetSpooledFiles_count(Object arg0, Object arg1) {
        return holder.format("IBMiGetSpooledFiles.count", arg0, arg1);
    }

    /**
     * Key {@code IBMiGetSpooledFiles.count}: {@code {0} spooled file(s)
     * retrieved in {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} spooled file(s) retrieved in {1}}
     */
    public static Localizable _IBMiGetSpooledFiles_count(Object arg0, Object arg1) {
        return new Localizable(holder, "IBMiGetSpooledFiles.count", arg0, arg1);
    }

    /**
     * Key {@code IBMiGlobalConfiguration.duplicated.servers}: {@code
     * Duplicated IBM i server name: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicated IBM i server name: {0}}
     */
    public static String IBMiGlobalConfiguration_duplicated_servers(Object arg0) {
        return holder.format("IBMiGlobalConfiguration.duplicated.servers", arg0);
    }

    /**
     * Key {@code IBMiGlobalConfiguration.duplicated.servers}: {@code
     * Duplicated IBM i server name: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicated IBM i server name: {0}}
     */
    public static Localizable _IBMiGlobalConfiguration_duplicated_servers(Object arg0) {
        return new Localizable(holder, "IBMiGlobalConfiguration.duplicated.servers", arg0);
    }

    /**
     * Key {@code IBMiDownloadSAVF.downloading}: {@code Downloading Save File
     * {0}/{1} into {2} ({3} bytes)}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Downloading Save File {0}/{1} into {2} ({3} bytes)}
     */
    public static String IBMiDownloadSAVF_downloading(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("IBMiDownloadSAVF.downloading", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code IBMiDownloadSAVF.downloading}: {@code Downloading Save File
     * {0}/{1} into {2} ({3} bytes)}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Downloading Save File {0}/{1} into {2} ({3} bytes)}
     */
    public static Localizable _IBMiDownloadSAVF_downloading(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "IBMiDownloadSAVF.downloading", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code using.ssl}: {@code (using SSL)}.
     * 
     * @return
     *     {@code (using SSL)}
     */
    public static String using_ssl() {
        return holder.format("using.ssl");
    }

    /**
     * Key {@code using.ssl}: {@code (using SSL)}.
     * 
     * @return
     *     {@code (using SSL)}
     */
    public static Localizable _using_ssl() {
        return new Localizable(holder, "using.ssl");
    }

    /**
     * Key {@code IBMICommandStep.description}: {@code Run an IBM i command}.
     * 
     * @return
     *     {@code Run an IBM i command}
     */
    public static String IBMICommandStep_description() {
        return holder.format("IBMICommandStep.description");
    }

    /**
     * Key {@code IBMICommandStep.description}: {@code Run an IBM i command}.
     * 
     * @return
     *     {@code Run an IBM i command}
     */
    public static Localizable _IBMICommandStep_description() {
        return new Localizable(holder, "IBMICommandStep.description");
    }

    /**
     * Key {@code IBMiRunSQLStep.updated}: {@code Query update count is {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Query update count is {0}}
     */
    public static String IBMiRunSQLStep_updated(Object arg0) {
        return holder.format("IBMiRunSQLStep.updated", arg0);
    }

    /**
     * Key {@code IBMiRunSQLStep.updated}: {@code Query update count is {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Query update count is {0}}
     */
    public static Localizable _IBMiRunSQLStep_updated(Object arg0) {
        return new Localizable(holder, "IBMiRunSQLStep.updated", arg0);
    }

    /**
     * Key {@code IBMiDownloadSAVF.description}: {@code Download a Save File
     * into the workspace}.
     * 
     * @return
     *     {@code Download a Save File into the workspace}
     */
    public static String IBMiDownloadSAVF_description() {
        return holder.format("IBMiDownloadSAVF.description");
    }

    /**
     * Key {@code IBMiDownloadSAVF.description}: {@code Download a Save File
     * into the workspace}.
     * 
     * @return
     *     {@code Download a Save File into the workspace}
     */
    public static Localizable _IBMiDownloadSAVF_description() {
        return new Localizable(holder, "IBMiDownloadSAVF.description");
    }

    /**
     * Key {@code IBMiPutIFSStep.failed.create.to}: {@code Failed to create
     * IFS folder {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to create IFS folder {0}}
     */
    public static String IBMiPutIFSStep_failed_create_to(Object arg0) {
        return holder.format("IBMiPutIFSStep.failed.create.to", arg0);
    }

    /**
     * Key {@code IBMiPutIFSStep.failed.create.to}: {@code Failed to create
     * IFS folder {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to create IFS folder {0}}
     */
    public static Localizable _IBMiPutIFSStep_failed_create_to(Object arg0) {
        return new Localizable(holder, "IBMiPutIFSStep.failed.create.to", arg0);
    }

    /**
     * Key {@code IBMiPutIFSStep.copy.file}: {@code Putting file {0} into
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Putting file {0} into {1}}
     */
    public static String IBMiPutIFSStep_copy_file(Object arg0, Object arg1) {
        return holder.format("IBMiPutIFSStep.copy.file", arg0, arg1);
    }

    /**
     * Key {@code IBMiPutIFSStep.copy.file}: {@code Putting file {0} into
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Putting file {0} into {1}}
     */
    public static Localizable _IBMiPutIFSStep_copy_file(Object arg0, Object arg1) {
        return new Localizable(holder, "IBMiPutIFSStep.copy.file", arg0, arg1);
    }

    /**
     * Key {@code IBMiDownloadSAVF.CPYTOSTMF.failed}: {@code Failed to copy
     * {0}/{1} to stream file {2}
     * {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to copy {0}/{1} to stream file {2}
     *     {3}}
     */
    public static String IBMiDownloadSAVF_CPYTOSTMF_failed(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("IBMiDownloadSAVF.CPYTOSTMF.failed", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code IBMiDownloadSAVF.CPYTOSTMF.failed}: {@code Failed to copy
     * {0}/{1} to stream file {2}
     * {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to copy {0}/{1} to stream file {2}
     *     {3}}
     */
    public static Localizable _IBMiDownloadSAVF_CPYTOSTMF_failed(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "IBMiDownloadSAVF.CPYTOSTMF.failed", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code IBMICommandStep.failed}: {@code IBM i command {0} failed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code IBM i command {0} failed}
     */
    public static String IBMICommandStep_failed(Object arg0) {
        return holder.format("IBMICommandStep.failed", arg0);
    }

    /**
     * Key {@code IBMICommandStep.failed}: {@code IBM i command {0} failed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code IBM i command {0} failed}
     */
    public static Localizable _IBMICommandStep_failed(Object arg0) {
        return new Localizable(holder, "IBMICommandStep.failed", arg0);
    }

}
