/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.hiddenlayer;

import com.hiddenlayer.api.models.scans.results.ScanReport;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.jenkins.plugins.hiddenlayer.FailOnDetectionSeverityEnum;
import io.jenkins.plugins.hiddenlayer.ModelScanServiceFactory;
import io.jenkins.plugins.hiddenlayer.ScanReporter;
import io.jenkins.plugins.hiddenlayer.ScannerService;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import jenkins.security.Roles;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class HLScanModelBuilder
extends Builder
implements SimpleBuildStep {
    private String modelName;
    private String hlClientId;
    private Secret hlClientSecret;
    private String folderToScan;
    private boolean failOnUnsupported;
    private FailOnDetectionSeverityEnum failOnSeverity;
    private transient ScannerService modelScanner;

    @DataBoundConstructor
    public HLScanModelBuilder(String modelName, String hlClientId, String hlClientSecret, String folderToScan, boolean failOnUnsupported, FailOnDetectionSeverityEnum failOnSeverity) {
        this.modelName = modelName;
        this.hlClientId = hlClientId;
        this.setHlClientSecret(hlClientSecret);
        this.folderToScan = folderToScan;
        this.failOnUnsupported = failOnUnsupported;
        this.failOnSeverity = failOnSeverity;
    }

    public String getModelName() {
        return this.modelName;
    }

    @DataBoundSetter
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getHlClientId() {
        return this.hlClientId;
    }

    @DataBoundSetter
    public void setHlClientId(String hlClientId) {
        this.hlClientId = hlClientId;
    }

    public Secret getHlClientSecret() {
        return this.hlClientSecret;
    }

    @DataBoundSetter
    public void setHlClientSecret(String hlClientSecret) {
        this.hlClientSecret = Secret.fromString((String)hlClientSecret);
    }

    public String getFolderToScan() {
        return this.folderToScan;
    }

    @DataBoundSetter
    public void setFolderToScan(String folderToScan) {
        this.folderToScan = folderToScan;
    }

    public boolean getFailOnUnsupported() {
        return this.failOnUnsupported;
    }

    @DataBoundSetter
    public void setFailOnUnsupported(boolean failOnUnsupported) {
        this.failOnUnsupported = failOnUnsupported;
    }

    public FailOnDetectionSeverityEnum getFailOnSeverity() {
        return this.failOnSeverity;
    }

    @DataBoundSetter
    public void setFailOnSeverity(FailOnDetectionSeverityEnum failOnSeverity) {
        this.failOnSeverity = failOnSeverity;
    }

    public ScannerService getModelScanner() {
        return this.modelScanner;
    }

    public void setModelScanner(ScannerService modelScanner) {
        this.modelScanner = modelScanner;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, final TaskListener listener) throws InterruptedException, IOException, AbortException {
        listener.getLogger().printf("Scanning model %s in folder %s ...%n", this.modelName, this.folderToScan);
        try {
            if (this.modelScanner == null) {
                this.modelScanner = ModelScanServiceFactory.getInstance(this.hlClientId, this.hlClientSecret);
            }
            FilePath folderPath = new FilePath(workspace, this.folderToScan);
            ScanReport report = (ScanReport)folderPath.act((FilePath.FileCallable)new FilePath.FileCallable<ScanReport>(){
                private static final long serialVersionUID = 1L;

                public ScanReport invoke(File f, VirtualChannel channel) {
                    String folder = f.getAbsolutePath();
                    try {
                        ScanReport report = HLScanModelBuilder.this.modelScanner.scanFolder(HLScanModelBuilder.this.modelName, folder);
                        return report;
                    }
                    catch (Exception e) {
                        listener.getLogger().println("Error scanning model: " + e.getMessage());
                        throw new RuntimeException(e);
                    }
                }

                public void checkRoles(RoleChecker checker) throws SecurityException {
                    checker.check((RoleSensitive)this, Roles.SLAVE);
                }
            });
            String summary = ScanReporter.summarizeScan(report);
            listener.getLogger().print(summary);
            ScanReport.Severity reportSeverity = report.severity().orElse(null);
            if (this.failOnUnsupported && (reportSeverity == null || ScanReport.Severity.UNKNOWN.equals((Object)reportSeverity))) {
                throw new AbortException("Model type is not supported by HiddenLayer");
            }
            if (this.failOnSeverity != FailOnDetectionSeverityEnum.NONE && reportSeverity != null && !ScanReport.Severity.UNKNOWN.equals((Object)reportSeverity) && !ScanReport.Severity.SAFE.equals((Object)reportSeverity)) {
                if (ScanReport.Severity.LOW.equals((Object)reportSeverity)) {
                    if (this.failOnSeverity == FailOnDetectionSeverityEnum.LOW) {
                        listener.getLogger().printf("Failing build due to model scan having a %s severity detection (threshold: %s)%n", new Object[]{reportSeverity, this.failOnSeverity});
                        throw new AbortException("Model has " + String.valueOf(reportSeverity) + " severity detection!");
                    }
                } else if (ScanReport.Severity.MEDIUM.equals((Object)reportSeverity)) {
                    if (this.failOnSeverity == FailOnDetectionSeverityEnum.MEDIUM || this.failOnSeverity == FailOnDetectionSeverityEnum.LOW) {
                        listener.getLogger().printf("Failing build due to model scan having a %s severity detection (threshold: %s)%n", new Object[]{reportSeverity, this.failOnSeverity});
                        throw new AbortException("Model has " + String.valueOf(reportSeverity) + " severity detection!");
                    }
                } else if (ScanReport.Severity.HIGH.equals((Object)reportSeverity)) {
                    if (this.failOnSeverity == FailOnDetectionSeverityEnum.HIGH || this.failOnSeverity == FailOnDetectionSeverityEnum.MEDIUM || this.failOnSeverity == FailOnDetectionSeverityEnum.LOW) {
                        listener.getLogger().printf("Failing build due to model scan having a %s severity detection (threshold: %s)%n", new Object[]{reportSeverity, this.failOnSeverity});
                        throw new AbortException("Model has " + String.valueOf(reportSeverity) + " severity detection!");
                    }
                } else {
                    if (ScanReport.Severity.CRITICAL.equals((Object)reportSeverity)) {
                        listener.getLogger().printf("Failing build due to model scan having a %s severity detection (threshold: %s)%n", new Object[]{reportSeverity, this.failOnSeverity});
                        throw new AbortException("Model has " + String.valueOf(reportSeverity) + " severity detection!");
                    }
                    listener.getLogger().println("Model has unknown severity level");
                }
            }
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception e) {
            listener.getLogger().println("Error scanning model: " + e.getMessage());
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            e.printStackTrace(pw);
            listener.getLogger().println(writer);
            throw new AbortException("Error scanning model: " + e.getMessage());
        }
    }

    @Extension
    @Symbol(value={"hlScanModel"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            super(HLScanModelBuilder.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Scan ML Model with HiddenLayer";
        }

        @POST
        public FormValidation doCheckModelName(@QueryParameter String value, @AncestorInPath Item item) {
            item.checkPermission(Item.CONFIGURE);
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)"Model Name cannot be empty");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckHlClientId(@QueryParameter String value, @AncestorInPath Item item) {
            item.checkPermission(Item.CONFIGURE);
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)"Client ID cannot be empty");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckHlClientSecret(@QueryParameter String value, @AncestorInPath Item item) {
            item.checkPermission(Item.CONFIGURE);
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)"Client Secret cannot be empty");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckFolderToScan(@QueryParameter String value, @AncestorInPath Item item) {
            item.checkPermission(Item.CONFIGURE);
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)"Folder to scan cannot be empty");
            }
            return FormValidation.ok();
        }
    }
}

