// CHECKSTYLE:OFF

package io.jenkins.plugins.gitlabserverconfig.servers;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code GitLabServers.displayName}: {@code GitLab}.
     * 
     * @return
     *     {@code GitLab}
     */
    public static String GitLabServers_displayName() {
        return holder.format("GitLabServers.displayName");
    }

    /**
     * Key {@code GitLabServers.displayName}: {@code GitLab}.
     * 
     * @return
     *     {@code GitLab}
     */
    public static Localizable _GitLabServers_displayName() {
        return new Localizable(holder, "GitLabServers.displayName");
    }

    /**
     * Key {@code GitLabServer.displayName}: {@code GitLab Server}.
     * 
     * @return
     *     {@code GitLab Server}
     */
    public static String GitLabServer_displayName() {
        return holder.format("GitLabServer.displayName");
    }

    /**
     * Key {@code GitLabServer.displayName}: {@code GitLab Server}.
     * 
     * @return
     *     {@code GitLab Server}
     */
    public static Localizable _GitLabServer_displayName() {
        return new Localizable(holder, "GitLabServer.displayName");
    }

    /**
     * Key {@code GitLabServer.serverVersion}: {@code GitLab Version: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code GitLab Version: {0}}
     */
    public static String GitLabServer_serverVersion(Object arg0) {
        return holder.format("GitLabServer.serverVersion", arg0);
    }

    /**
     * Key {@code GitLabServer.serverVersion}: {@code GitLab Version: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code GitLab Version: {0}}
     */
    public static Localizable _GitLabServer_serverVersion(Object arg0) {
        return new Localizable(holder, "GitLabServer.serverVersion", arg0);
    }

    /**
     * Key {@code GitLabServer.failedValidation}: {@code Failed to validate

     * the account {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to validate the account {0}}
     */
    public static String GitLabServer_failedValidation(Object arg0) {
        return holder.format("GitLabServer.failedValidation", arg0);
    }

    /**
     * Key {@code GitLabServer.failedValidation}: {@code Failed to validate

     * the account {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to validate the account {0}}
     */
    public static Localizable _GitLabServer_failedValidation(Object arg0) {
        return new Localizable(holder, "GitLabServer.failedValidation", arg0);
    }

    /**
     * Key {@code GitLabServer.credentialsNotResolved}: {@code Cannot resolve

     * suitable credentials with id: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot resolve suitable credentials with id: {0}}
     */
    public static String GitLabServer_credentialsNotResolved(Object arg0) {
        return holder.format("GitLabServer.credentialsNotResolved", arg0);
    }

    /**
     * Key {@code GitLabServer.credentialsNotResolved}: {@code Cannot resolve

     * suitable credentials with id: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot resolve suitable credentials with id: {0}}
     */
    public static Localizable _GitLabServer_credentialsNotResolved(Object arg0) {
        return new Localizable(holder, "GitLabServer.credentialsNotResolved", arg0);
    }

    /**
     * Key {@code GitLabServer.validateInterrupted}: {@code Interrupted while

     * trying to validate credentials}.
     * 
     * @return
     *     {@code Interrupted while trying to validate credentials}
     */
    public static String GitLabServer_validateInterrupted() {
        return holder.format("GitLabServer.validateInterrupted");
    }

    /**
     * Key {@code GitLabServer.validateInterrupted}: {@code Interrupted while

     * trying to validate credentials}.
     * 
     * @return
     *     {@code Interrupted while trying to validate credentials}
     */
    public static Localizable _GitLabServer_validateInterrupted() {
        return new Localizable(holder, "GitLabServer.validateInterrupted");
    }

    /**
     * Key {@code GitLabServer.versionInterrupted}: {@code Interrupted while

     * trying to determine server version}.
     * 
     * @return
     *     {@code Interrupted while trying to determine server version}
     */
    public static String GitLabServer_versionInterrupted() {
        return holder.format("GitLabServer.versionInterrupted");
    }

    /**
     * Key {@code GitLabServer.versionInterrupted}: {@code Interrupted while

     * trying to determine server version}.
     * 
     * @return
     *     {@code Interrupted while trying to determine server version}
     */
    public static Localizable _GitLabServer_versionInterrupted() {
        return new Localizable(holder, "GitLabServer.versionInterrupted");
    }

    /**
     * Key {@code GitLabServer.advancedSectionForFuture}: {@code Advanced

     * configurations will be added in later release}.
     * 
     * @return
     *     {@code Advanced configurations will be added in later release}
     */
    public static String GitLabServer_advancedSectionForFuture() {
        return holder.format("GitLabServer.advancedSectionForFuture");
    }

    /**
     * Key {@code GitLabServer.advancedSectionForFuture}: {@code Advanced

     * configurations will be added in later release}.
     * 
     * @return
     *     {@code Advanced configurations will be added in later release}
     */
    public static Localizable _GitLabServer_advancedSectionForFuture() {
        return new Localizable(holder, "GitLabServer.advancedSectionForFuture");
    }

    /**
     * Key {@code GitLabServer.invalidUrl}: {@code Invalid GitLab Server URL:

     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid GitLab Server URL: {0}}
     */
    public static String GitLabServer_invalidUrl(Object arg0) {
        return holder.format("GitLabServer.invalidUrl", arg0);
    }

    /**
     * Key {@code GitLabServer.invalidUrl}: {@code Invalid GitLab Server URL:

     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid GitLab Server URL: {0}}
     */
    public static Localizable _GitLabServer_invalidUrl(Object arg0) {
        return new Localizable(holder, "GitLabServer.invalidUrl", arg0);
    }

    /**
     * Key {@code GitLabServer.hookManagementAs}: {@code Hook management will

     * be performed as {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Hook management will be performed as {0}}
     */
    public static String GitLabServer_hookManagementAs(Object arg0) {
        return holder.format("GitLabServer.hookManagementAs", arg0);
    }

    /**
     * Key {@code GitLabServer.hookManagementAs}: {@code Hook management will

     * be performed as {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Hook management will be performed as {0}}
     */
    public static Localizable _GitLabServer_hookManagementAs(Object arg0) {
        return new Localizable(holder, "GitLabServer.hookManagementAs", arg0);
    }

}
