// CHECKSTYLE:OFF

package io.jenkins.plugins.gitlabbranchsource;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code GitLabWebHookCause.ShortDescription.Push}: {@code Started

     * by GitLab push by {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by GitLab push by {0}}
     */
    public static String GitLabWebHookCause_ShortDescription_Push(Object arg0) {
        return holder.format("GitLabWebHookCause.ShortDescription.Push", arg0);
    }

    /**
     * Key {@code GitLabWebHookCause.ShortDescription.Push}: {@code Started

     * by GitLab push by {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by GitLab push by {0}}
     */
    public static Localizable _GitLabWebHookCause_ShortDescription_Push(Object arg0) {
        return new Localizable(holder, "GitLabWebHookCause.ShortDescription.Push", arg0);
    }

    /**
     * Key {@code ProjectNamingStrategyTrait.displayName}: {@code Project

     * Naming Strategy}.
     * 
     * @return
     *     {@code Project Naming Strategy}
     */
    public static String ProjectNamingStrategyTrait_displayName() {
        return holder.format("ProjectNamingStrategyTrait.displayName");
    }

    /**
     * Key {@code ProjectNamingStrategyTrait.displayName}: {@code Project

     * Naming Strategy}.
     * 
     * @return
     *     {@code Project Naming Strategy}
     */
    public static Localizable _ProjectNamingStrategyTrait_displayName() {
        return new Localizable(holder, "ProjectNamingStrategyTrait.displayName");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.contributorsDisplayName}:

     * {@code Members}.
     * 
     * @return
     *     {@code Members}
     */
    public static String ForkMergeRequestDiscoveryTrait_contributorsDisplayName() {
        return holder.format("ForkMergeRequestDiscoveryTrait.contributorsDisplayName");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.contributorsDisplayName}:

     * {@code Members}.
     * 
     * @return
     *     {@code Members}
     */
    public static Localizable _ForkMergeRequestDiscoveryTrait_contributorsDisplayName() {
        return new Localizable(holder, "ForkMergeRequestDiscoveryTrait.contributorsDisplayName");
    }

    /**
     * Key {@code GitLabSCMNavigator.traitSection_projects}: {@code

     * Projects}.
     * 
     * @return
     *     {@code Projects}
     */
    public static String GitLabSCMNavigator_traitSection_projects() {
        return holder.format("GitLabSCMNavigator.traitSection_projects");
    }

    /**
     * Key {@code GitLabSCMNavigator.traitSection_projects}: {@code

     * Projects}.
     * 
     * @return
     *     {@code Projects}
     */
    public static Localizable _GitLabSCMNavigator_traitSection_projects() {
        return new Localizable(holder, "GitLabSCMNavigator.traitSection_projects");
    }

    /**
     * Key {@code LogCommentTrait.displayName}: {@code Log build status as

     * comment on GitLab}.
     * 
     * @return
     *     {@code Log build status as comment on GitLab}
     */
    public static String LogCommentTrait_displayName() {
        return holder.format("LogCommentTrait.displayName");
    }

    /**
     * Key {@code LogCommentTrait.displayName}: {@code Log build status as

     * comment on GitLab}.
     * 
     * @return
     *     {@code Log build status as comment on GitLab}
     */
    public static Localizable _LogCommentTrait_displayName() {
        return new Localizable(holder, "LogCommentTrait.displayName");
    }

    /**
     * Key {@code ProjectNamingStrategyTrait.projectName}: {@code Project

     * Name}.
     * 
     * @return
     *     {@code Project Name}
     */
    public static String ProjectNamingStrategyTrait_projectName() {
        return holder.format("ProjectNamingStrategyTrait.projectName");
    }

    /**
     * Key {@code ProjectNamingStrategyTrait.projectName}: {@code Project

     * Name}.
     * 
     * @return
     *     {@code Project Name}
     */
    public static Localizable _ProjectNamingStrategyTrait_projectName() {
        return new Localizable(holder, "ProjectNamingStrategyTrait.projectName");
    }

    /**
     * Key {@code GitLabSCMSource.Pronoun}: {@code GitLab Project}.
     * 
     * @return
     *     {@code GitLab Project}
     */
    public static String GitLabSCMSource_Pronoun() {
        return holder.format("GitLabSCMSource.Pronoun");
    }

    /**
     * Key {@code GitLabSCMSource.Pronoun}: {@code GitLab Project}.
     * 
     * @return
     *     {@code GitLab Project}
     */
    public static Localizable _GitLabSCMSource_Pronoun() {
        return new Localizable(holder, "GitLabSCMSource.Pronoun");
    }

    /**
     * Key {@code BranchDiscoveryTrait.authorityDisplayName}: {@code Trust

     * origin branches}.
     * 
     * @return
     *     {@code Trust origin branches}
     */
    public static String BranchDiscoveryTrait_authorityDisplayName() {
        return holder.format("BranchDiscoveryTrait.authorityDisplayName");
    }

    /**
     * Key {@code BranchDiscoveryTrait.authorityDisplayName}: {@code Trust

     * origin branches}.
     * 
     * @return
     *     {@code Trust origin branches}
     */
    public static Localizable _BranchDiscoveryTrait_authorityDisplayName() {
        return new Localizable(holder, "BranchDiscoveryTrait.authorityDisplayName");
    }

    /**
     * Key {@code BranchDiscoveryTrait.onlyMRs}: {@code Only branches that

     * are also filed as MRs}.
     * 
     * @return
     *     {@code Only branches that are also filed as MRs}
     */
    public static String BranchDiscoveryTrait_onlyMRs() {
        return holder.format("BranchDiscoveryTrait.onlyMRs");
    }

    /**
     * Key {@code BranchDiscoveryTrait.onlyMRs}: {@code Only branches that

     * are also filed as MRs}.
     * 
     * @return
     *     {@code Only branches that are also filed as MRs}
     */
    public static Localizable _BranchDiscoveryTrait_onlyMRs() {
        return new Localizable(holder, "BranchDiscoveryTrait.onlyMRs");
    }

    /**
     * Key {@code GitLabSCMNavigator.description}: {@code Scans a GitLab

     * Group (or user account) for all projects matching some defined

     * markers.}.
     * 
     * @return
     *     {@code Scans a GitLab Group (or user account) for all projects

     *     matching some defined markers.}
     */
    public static String GitLabSCMNavigator_description() {
        return holder.format("GitLabSCMNavigator.description");
    }

    /**
     * Key {@code GitLabSCMNavigator.description}: {@code Scans a GitLab

     * Group (or user account) for all projects matching some defined

     * markers.}.
     * 
     * @return
     *     {@code Scans a GitLab Group (or user account) for all projects

     *     matching some defined markers.}
     */
    public static Localizable _GitLabSCMNavigator_description() {
        return new Localizable(holder, "GitLabSCMNavigator.description");
    }

    /**
     * Key {@code GitLabSCMSource.ChangeRequestCategory}: {@code Merge

     * Requests}.
     * 
     * @return
     *     {@code Merge Requests}
     */
    public static String GitLabSCMSource_ChangeRequestCategory() {
        return holder.format("GitLabSCMSource.ChangeRequestCategory");
    }

    /**
     * Key {@code GitLabSCMSource.ChangeRequestCategory}: {@code Merge

     * Requests}.
     * 
     * @return
     *     {@code Merge Requests}
     */
    public static Localizable _GitLabSCMSource_ChangeRequestCategory() {
        return new Localizable(holder, "GitLabSCMSource.ChangeRequestCategory");
    }

    /**
     * Key {@code MergeRequestSCMHead.Pronoun}: {@code Merge Request}.
     * 
     * @return
     *     {@code Merge Request}
     */
    public static String MergeRequestSCMHead_Pronoun() {
        return holder.format("MergeRequestSCMHead.Pronoun");
    }

    /**
     * Key {@code MergeRequestSCMHead.Pronoun}: {@code Merge Request}.
     * 
     * @return
     *     {@code Merge Request}
     */
    public static Localizable _MergeRequestSCMHead_Pronoun() {
        return new Localizable(holder, "MergeRequestSCMHead.Pronoun");
    }

    /**
     * Key {@code GitLabSCMSource.TagCategory}: {@code Tags}.
     * 
     * @return
     *     {@code Tags}
     */
    public static String GitLabSCMSource_TagCategory() {
        return holder.format("GitLabSCMSource.TagCategory");
    }

    /**
     * Key {@code GitLabSCMSource.TagCategory}: {@code Tags}.
     * 
     * @return
     *     {@code Tags}
     */
    public static Localizable _GitLabSCMSource_TagCategory() {
        return new Localizable(holder, "GitLabSCMSource.TagCategory");
    }

    /**
     * Key {@code GitLabSCMNavigator.traitSection_withinRepo}: {@code Within

     * project}.
     * 
     * @return
     *     {@code Within project}
     */
    public static String GitLabSCMNavigator_traitSection_withinRepo() {
        return holder.format("GitLabSCMNavigator.traitSection_withinRepo");
    }

    /**
     * Key {@code GitLabSCMNavigator.traitSection_withinRepo}: {@code Within

     * project}.
     * 
     * @return
     *     {@code Within project}
     */
    public static Localizable _GitLabSCMNavigator_traitSection_withinRepo() {
        return new Localizable(holder, "GitLabSCMNavigator.traitSection_withinRepo");
    }

    /**
     * Key {@code HookRegistrationTrait.disable}: {@code Disable {0}

     * management}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Disable {0} management}
     */
    public static String HookRegistrationTrait_disable(Object arg0) {
        return holder.format("HookRegistrationTrait.disable", arg0);
    }

    /**
     * Key {@code HookRegistrationTrait.disable}: {@code Disable {0}

     * management}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Disable {0} management}
     */
    public static Localizable _HookRegistrationTrait_disable(Object arg0) {
        return new Localizable(holder, "HookRegistrationTrait.disable", arg0);
    }

    /**
     * Key {@code GitLabSCMSource.selectedCredentialsMissing}: {@code Cannot

     * find currently selected credentials}.
     * 
     * @return
     *     {@code Cannot find currently selected credentials}
     */
    public static String GitLabSCMSource_selectedCredentialsMissing() {
        return holder.format("GitLabSCMSource.selectedCredentialsMissing");
    }

    /**
     * Key {@code GitLabSCMSource.selectedCredentialsMissing}: {@code Cannot

     * find currently selected credentials}.
     * 
     * @return
     *     {@code Cannot find currently selected credentials}
     */
    public static Localizable _GitLabSCMSource_selectedCredentialsMissing() {
        return new Localizable(holder, "GitLabSCMSource.selectedCredentialsMissing");
    }

    /**
     * Key {@code OriginMergeRequestDiscoveryTrait.authorityDisplayName}:

     * {@code Trust origin merge requests}.
     * 
     * @return
     *     {@code Trust origin merge requests}
     */
    public static String OriginMergeRequestDiscoveryTrait_authorityDisplayName() {
        return holder.format("OriginMergeRequestDiscoveryTrait.authorityDisplayName");
    }

    /**
     * Key {@code OriginMergeRequestDiscoveryTrait.authorityDisplayName}:

     * {@code Trust origin merge requests}.
     * 
     * @return
     *     {@code Trust origin merge requests}
     */
    public static Localizable _OriginMergeRequestDiscoveryTrait_authorityDisplayName() {
        return new Localizable(holder, "OriginMergeRequestDiscoveryTrait.authorityDisplayName");
    }

    /**
     * Key {@code SharedProjectsDiscoveryTrait.displayName}: {@code Discover

     * shared projects}.
     * 
     * @return
     *     {@code Discover shared projects}
     */
    public static String SharedProjectsDiscoveryTrait_displayName() {
        return holder.format("SharedProjectsDiscoveryTrait.displayName");
    }

    /**
     * Key {@code SharedProjectsDiscoveryTrait.displayName}: {@code Discover

     * shared projects}.
     * 
     * @return
     *     {@code Discover shared projects}
     */
    public static Localizable _SharedProjectsDiscoveryTrait_displayName() {
        return new Localizable(holder, "SharedProjectsDiscoveryTrait.displayName");
    }

    /**
     * Key {@code ProjectNamingStrategyTrait.simpleProjectPath}: {@code

     * Simple Project Path}.
     * 
     * @return
     *     {@code Simple Project Path}
     */
    public static String ProjectNamingStrategyTrait_simpleProjectPath() {
        return holder.format("ProjectNamingStrategyTrait.simpleProjectPath");
    }

    /**
     * Key {@code ProjectNamingStrategyTrait.simpleProjectPath}: {@code

     * Simple Project Path}.
     * 
     * @return
     *     {@code Simple Project Path}
     */
    public static Localizable _ProjectNamingStrategyTrait_simpleProjectPath() {
        return new Localizable(holder, "ProjectNamingStrategyTrait.simpleProjectPath");
    }

    /**
     * Key {@code GitLabSCMNavigator.selectedCredentialsMissing}: {@code

     * Cannot find currently selected credentials}.
     * 
     * @return
     *     {@code Cannot find currently selected credentials}
     */
    public static String GitLabSCMNavigator_selectedCredentialsMissing() {
        return holder.format("GitLabSCMNavigator.selectedCredentialsMissing");
    }

    /**
     * Key {@code GitLabSCMNavigator.selectedCredentialsMissing}: {@code

     * Cannot find currently selected credentials}.
     * 
     * @return
     *     {@code Cannot find currently selected credentials}
     */
    public static Localizable _GitLabSCMNavigator_selectedCredentialsMissing() {
        return new Localizable(holder, "GitLabSCMNavigator.selectedCredentialsMissing");
    }

    /**
     * Key {@code TagDiscoveryTrait.displayName}: {@code Discover tags}.
     * 
     * @return
     *     {@code Discover tags}
     */
    public static String TagDiscoveryTrait_displayName() {
        return holder.format("TagDiscoveryTrait.displayName");
    }

    /**
     * Key {@code TagDiscoveryTrait.displayName}: {@code Discover tags}.
     * 
     * @return
     *     {@code Discover tags}
     */
    public static Localizable _TagDiscoveryTrait_displayName() {
        return new Localizable(holder, "TagDiscoveryTrait.displayName");
    }

    /**
     * Key {@code GitLabSCMNavigator.displayName}: {@code GitLab Group}.
     * 
     * @return
     *     {@code GitLab Group}
     */
    public static String GitLabSCMNavigator_displayName() {
        return holder.format("GitLabSCMNavigator.displayName");
    }

    /**
     * Key {@code GitLabSCMNavigator.displayName}: {@code GitLab Group}.
     * 
     * @return
     *     {@code GitLab Group}
     */
    public static Localizable _GitLabSCMNavigator_displayName() {
        return new Localizable(holder, "GitLabSCMNavigator.displayName");
    }

    /**
     * Key {@code TagDiscoveryTrait.authorityDisplayName}: {@code Trust

     * origin tags}.
     * 
     * @return
     *     {@code Trust origin tags}
     */
    public static String TagDiscoveryTrait_authorityDisplayName() {
        return holder.format("TagDiscoveryTrait.authorityDisplayName");
    }

    /**
     * Key {@code TagDiscoveryTrait.authorityDisplayName}: {@code Trust

     * origin tags}.
     * 
     * @return
     *     {@code Trust origin tags}
     */
    public static Localizable _TagDiscoveryTrait_authorityDisplayName() {
        return new Localizable(holder, "TagDiscoveryTrait.authorityDisplayName");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.everyoneDisplayName}: {@code

     * Everyone}.
     * 
     * @return
     *     {@code Everyone}
     */
    public static String ForkMergeRequestDiscoveryTrait_everyoneDisplayName() {
        return holder.format("ForkMergeRequestDiscoveryTrait.everyoneDisplayName");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.everyoneDisplayName}: {@code

     * Everyone}.
     * 
     * @return
     *     {@code Everyone}
     */
    public static Localizable _ForkMergeRequestDiscoveryTrait_everyoneDisplayName() {
        return new Localizable(holder, "ForkMergeRequestDiscoveryTrait.everyoneDisplayName");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.headAndMerge}: {@code Both

     * the current merge request revision and the merge request merged with

     * the current target branch revision}.
     * 
     * @return
     *     {@code Both the current merge request revision and the merge request

     *     merged with the current target branch revision}
     */
    public static String ForkMergeRequestDiscoveryTrait_headAndMerge() {
        return holder.format("ForkMergeRequestDiscoveryTrait.headAndMerge");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.headAndMerge}: {@code Both

     * the current merge request revision and the merge request merged with

     * the current target branch revision}.
     * 
     * @return
     *     {@code Both the current merge request revision and the merge request

     *     merged with the current target branch revision}
     */
    public static Localizable _ForkMergeRequestDiscoveryTrait_headAndMerge() {
        return new Localizable(holder, "ForkMergeRequestDiscoveryTrait.headAndMerge");
    }

    /**
     * Key {@code GitLabSkipNotificationsTrait.displayName}: {@code Skip

     * pipeline status notifications}.
     * 
     * @return
     *     {@code Skip pipeline status notifications}
     */
    public static String GitLabSkipNotificationsTrait_displayName() {
        return holder.format("GitLabSkipNotificationsTrait.displayName");
    }

    /**
     * Key {@code GitLabSkipNotificationsTrait.displayName}: {@code Skip

     * pipeline status notifications}.
     * 
     * @return
     *     {@code Skip pipeline status notifications}
     */
    public static Localizable _GitLabSkipNotificationsTrait_displayName() {
        return new Localizable(holder, "GitLabSkipNotificationsTrait.displayName");
    }

    /**
     * Key {@code GitLabMarkUnstableAsSuccessTrait.displayName}: {@code Mark

     * unstable build as successful on Gitlab}.
     * 
     * @return
     *     {@code Mark unstable build as successful on Gitlab}
     */
    public static String GitLabMarkUnstableAsSuccessTrait_displayName() {
        return holder.format("GitLabMarkUnstableAsSuccessTrait.displayName");
    }

    /**
     * Key {@code GitLabMarkUnstableAsSuccessTrait.displayName}: {@code Mark

     * unstable build as successful on Gitlab}.
     * 
     * @return
     *     {@code Mark unstable build as successful on Gitlab}
     */
    public static Localizable _GitLabMarkUnstableAsSuccessTrait_displayName() {
        return new Localizable(holder, "GitLabMarkUnstableAsSuccessTrait.displayName");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.mergeOnly}: {@code Merging

     * the merge request with the current target branch revision}.
     * 
     * @return
     *     {@code Merging the merge request with the current target branch

     *     revision}
     */
    public static String ForkMergeRequestDiscoveryTrait_mergeOnly() {
        return holder.format("ForkMergeRequestDiscoveryTrait.mergeOnly");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.mergeOnly}: {@code Merging

     * the merge request with the current target branch revision}.
     * 
     * @return
     *     {@code Merging the merge request with the current target branch

     *     revision}
     */
    public static Localizable _ForkMergeRequestDiscoveryTrait_mergeOnly() {
        return new Localizable(holder, "ForkMergeRequestDiscoveryTrait.mergeOnly");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.displayName}: {@code

     * Discover merge requests from forks}.
     * 
     * @return
     *     {@code Discover merge requests from forks}
     */
    public static String ForkMergeRequestDiscoveryTrait_displayName() {
        return holder.format("ForkMergeRequestDiscoveryTrait.displayName");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.displayName}: {@code

     * Discover merge requests from forks}.
     * 
     * @return
     *     {@code Discover merge requests from forks}
     */
    public static Localizable _ForkMergeRequestDiscoveryTrait_displayName() {
        return new Localizable(holder, "ForkMergeRequestDiscoveryTrait.displayName");
    }

    /**
     * Key {@code GitLabWebHookCause.ShortDescription.Push_noUser}: {@code

     * Started by GitLab push}.
     * 
     * @return
     *     {@code Started by GitLab push}
     */
    public static String GitLabWebHookCause_ShortDescription_Push_noUser() {
        return holder.format("GitLabWebHookCause.ShortDescription.Push_noUser");
    }

    /**
     * Key {@code GitLabWebHookCause.ShortDescription.Push_noUser}: {@code

     * Started by GitLab push}.
     * 
     * @return
     *     {@code Started by GitLab push}
     */
    public static Localizable _GitLabWebHookCause_ShortDescription_Push_noUser() {
        return new Localizable(holder, "GitLabWebHookCause.ShortDescription.Push_noUser");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.permissionsDisplayName}:

     * {@code Trusted Members}.
     * 
     * @return
     *     {@code Trusted Members}
     */
    public static String ForkMergeRequestDiscoveryTrait_permissionsDisplayName() {
        return holder.format("ForkMergeRequestDiscoveryTrait.permissionsDisplayName");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.permissionsDisplayName}:

     * {@code Trusted Members}.
     * 
     * @return
     *     {@code Trusted Members}
     */
    public static Localizable _ForkMergeRequestDiscoveryTrait_permissionsDisplayName() {
        return new Localizable(holder, "ForkMergeRequestDiscoveryTrait.permissionsDisplayName");
    }

    /**
     * Key {@code GitLabSCMSource.DisplayName}: {@code GitLab Project}.
     * 
     * @return
     *     {@code GitLab Project}
     */
    public static String GitLabSCMSource_DisplayName() {
        return holder.format("GitLabSCMSource.DisplayName");
    }

    /**
     * Key {@code GitLabSCMSource.DisplayName}: {@code GitLab Project}.
     * 
     * @return
     *     {@code GitLab Project}
     */
    public static Localizable _GitLabSCMSource_DisplayName() {
        return new Localizable(holder, "GitLabSCMSource.DisplayName");
    }

    /**
     * Key {@code SSHCheckoutTrait.displayName}: {@code Checkout over SSH}.
     * 
     * @return
     *     {@code Checkout over SSH}
     */
    public static String SSHCheckoutTrait_displayName() {
        return holder.format("SSHCheckoutTrait.displayName");
    }

    /**
     * Key {@code SSHCheckoutTrait.displayName}: {@code Checkout over SSH}.
     * 
     * @return
     *     {@code Checkout over SSH}
     */
    public static Localizable _SSHCheckoutTrait_displayName() {
        return new Localizable(holder, "SSHCheckoutTrait.displayName");
    }

    /**
     * Key {@code GitLabSCMSource.traitSection_additional}: {@code

     * Additional}.
     * 
     * @return
     *     {@code Additional}
     */
    public static String GitLabSCMSource_traitSection_additional() {
        return holder.format("GitLabSCMSource.traitSection_additional");
    }

    /**
     * Key {@code GitLabSCMSource.traitSection_additional}: {@code

     * Additional}.
     * 
     * @return
     *     {@code Additional}
     */
    public static Localizable _GitLabSCMSource_traitSection_additional() {
        return new Localizable(holder, "GitLabSCMSource.traitSection_additional");
    }

    /**
     * Key {@code GitLabBrowser.displayName}: {@code GitLab}.
     * 
     * @return
     *     {@code GitLab}
     */
    public static String GitLabBrowser_displayName() {
        return holder.format("GitLabBrowser.displayName");
    }

    /**
     * Key {@code GitLabBrowser.displayName}: {@code GitLab}.
     * 
     * @return
     *     {@code GitLab}
     */
    public static Localizable _GitLabBrowser_displayName() {
        return new Localizable(holder, "GitLabBrowser.displayName");
    }

    /**
     * Key {@code HookRegistrationTrait.useSystem}: {@code Use System

     * credentials for {0} management mode (default)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Use System credentials for {0} management mode (default)}
     */
    public static String HookRegistrationTrait_useSystem(Object arg0) {
        return holder.format("HookRegistrationTrait.useSystem", arg0);
    }

    /**
     * Key {@code HookRegistrationTrait.useSystem}: {@code Use System

     * credentials for {0} management mode (default)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Use System credentials for {0} management mode (default)}
     */
    public static Localizable _HookRegistrationTrait_useSystem(Object arg0) {
        return new Localizable(holder, "HookRegistrationTrait.useSystem", arg0);
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.nobodyDisplayName}: {@code

     * Nobody}.
     * 
     * @return
     *     {@code Nobody}
     */
    public static String ForkMergeRequestDiscoveryTrait_nobodyDisplayName() {
        return holder.format("ForkMergeRequestDiscoveryTrait.nobodyDisplayName");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.nobodyDisplayName}: {@code

     * Nobody}.
     * 
     * @return
     *     {@code Nobody}
     */
    public static Localizable _ForkMergeRequestDiscoveryTrait_nobodyDisplayName() {
        return new Localizable(holder, "ForkMergeRequestDiscoveryTrait.nobodyDisplayName");
    }

    /**
     * Key {@code ProjectNamingStrategyTrait.contextualProjectPath}: {@code

     * Contextual Project Path}.
     * 
     * @return
     *     {@code Contextual Project Path}
     */
    public static String ProjectNamingStrategyTrait_contextualProjectPath() {
        return holder.format("ProjectNamingStrategyTrait.contextualProjectPath");
    }

    /**
     * Key {@code ProjectNamingStrategyTrait.contextualProjectPath}: {@code

     * Contextual Project Path}.
     * 
     * @return
     *     {@code Contextual Project Path}
     */
    public static Localizable _ProjectNamingStrategyTrait_contextualProjectPath() {
        return new Localizable(holder, "ProjectNamingStrategyTrait.contextualProjectPath");
    }

    /**
     * Key {@code GitLabAvatarTrait.displayName}: {@code Disable GitLab

     * project avatars}.
     * 
     * @return
     *     {@code Disable GitLab project avatars}
     */
    public static String GitLabAvatarTrait_displayName() {
        return holder.format("GitLabAvatarTrait.displayName");
    }

    /**
     * Key {@code GitLabAvatarTrait.displayName}: {@code Disable GitLab

     * project avatars}.
     * 
     * @return
     *     {@code Disable GitLab project avatars}
     */
    public static Localizable _GitLabAvatarTrait_displayName() {
        return new Localizable(holder, "GitLabAvatarTrait.displayName");
    }

    /**
     * Key {@code SSHCheckoutTrait.missingCredentials}: {@code The currently

     * configured credentials cannot be found}.
     * 
     * @return
     *     {@code The currently configured credentials cannot be found}
     */
    public static String SSHCheckoutTrait_missingCredentials() {
        return holder.format("SSHCheckoutTrait.missingCredentials");
    }

    /**
     * Key {@code SSHCheckoutTrait.missingCredentials}: {@code The currently

     * configured credentials cannot be found}.
     * 
     * @return
     *     {@code The currently configured credentials cannot be found}
     */
    public static Localizable _SSHCheckoutTrait_missingCredentials() {
        return new Localizable(holder, "SSHCheckoutTrait.missingCredentials");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.headOnly}: {@code The

     * current merge request revision}.
     * 
     * @return
     *     {@code The current merge request revision}
     */
    public static String ForkMergeRequestDiscoveryTrait_headOnly() {
        return holder.format("ForkMergeRequestDiscoveryTrait.headOnly");
    }

    /**
     * Key {@code ForkMergeRequestDiscoveryTrait.headOnly}: {@code The

     * current merge request revision}.
     * 
     * @return
     *     {@code The current merge request revision}
     */
    public static Localizable _ForkMergeRequestDiscoveryTrait_headOnly() {
        return new Localizable(holder, "ForkMergeRequestDiscoveryTrait.headOnly");
    }

    /**
     * Key {@code TriggerMRCommentTrait.displayName}: {@code Trigger build on

     * merge request comment}.
     * 
     * @return
     *     {@code Trigger build on merge request comment}
     */
    public static String TriggerMRCommentTrait_displayName() {
        return holder.format("TriggerMRCommentTrait.displayName");
    }

    /**
     * Key {@code TriggerMRCommentTrait.displayName}: {@code Trigger build on

     * merge request comment}.
     * 
     * @return
     *     {@code Trigger build on merge request comment}
     */
    public static Localizable _TriggerMRCommentTrait_displayName() {
        return new Localizable(holder, "TriggerMRCommentTrait.displayName");
    }

    /**
     * Key {@code SSHCheckoutTrait.useAgentKey}: {@code - use build agent''s

     * key -}.
     * 
     * @return
     *     {@code - use build agent''s key -}
     */
    public static String SSHCheckoutTrait_useAgentKey() {
        return holder.format("SSHCheckoutTrait.useAgentKey");
    }

    /**
     * Key {@code SSHCheckoutTrait.useAgentKey}: {@code - use build agent''s

     * key -}.
     * 
     * @return
     *     {@code - use build agent''s key -}
     */
    public static Localizable _SSHCheckoutTrait_useAgentKey() {
        return new Localizable(holder, "SSHCheckoutTrait.useAgentKey");
    }

    /**
     * Key {@code BranchDiscoveryTrait.allBranches}: {@code All branches}.
     * 
     * @return
     *     {@code All branches}
     */
    public static String BranchDiscoveryTrait_allBranches() {
        return holder.format("BranchDiscoveryTrait.allBranches");
    }

    /**
     * Key {@code BranchDiscoveryTrait.allBranches}: {@code All branches}.
     * 
     * @return
     *     {@code All branches}
     */
    public static Localizable _BranchDiscoveryTrait_allBranches() {
        return new Localizable(holder, "BranchDiscoveryTrait.allBranches");
    }

    /**
     * Key {@code GitLabSCMSource.traitSection_withinRepo}: {@code Within

     * project}.
     * 
     * @return
     *     {@code Within project}
     */
    public static String GitLabSCMSource_traitSection_withinRepo() {
        return holder.format("GitLabSCMSource.traitSection_withinRepo");
    }

    /**
     * Key {@code GitLabSCMSource.traitSection_withinRepo}: {@code Within

     * project}.
     * 
     * @return
     *     {@code Within project}
     */
    public static Localizable _GitLabSCMSource_traitSection_withinRepo() {
        return new Localizable(holder, "GitLabSCMSource.traitSection_withinRepo");
    }

    /**
     * Key {@code BranchDiscoveryTrait.displayName}: {@code Discover

     * branches}.
     * 
     * @return
     *     {@code Discover branches}
     */
    public static String BranchDiscoveryTrait_displayName() {
        return holder.format("BranchDiscoveryTrait.displayName");
    }

    /**
     * Key {@code BranchDiscoveryTrait.displayName}: {@code Discover

     * branches}.
     * 
     * @return
     *     {@code Discover branches}
     */
    public static Localizable _BranchDiscoveryTrait_displayName() {
        return new Localizable(holder, "BranchDiscoveryTrait.displayName");
    }

    /**
     * Key {@code GitLabSCMNavigator.traitSection_additional}: {@code

     * Additional}.
     * 
     * @return
     *     {@code Additional}
     */
    public static String GitLabSCMNavigator_traitSection_additional() {
        return holder.format("GitLabSCMNavigator.traitSection_additional");
    }

    /**
     * Key {@code GitLabSCMNavigator.traitSection_additional}: {@code

     * Additional}.
     * 
     * @return
     *     {@code Additional}
     */
    public static Localizable _GitLabSCMNavigator_traitSection_additional() {
        return new Localizable(holder, "GitLabSCMNavigator.traitSection_additional");
    }

    /**
     * Key {@code BranchDiscoveryTrait.excludeMRs}: {@code Only branches that

     * are not also filed as MRs}.
     * 
     * @return
     *     {@code Only branches that are not also filed as MRs}
     */
    public static String BranchDiscoveryTrait_excludeMRs() {
        return holder.format("BranchDiscoveryTrait.excludeMRs");
    }

    /**
     * Key {@code BranchDiscoveryTrait.excludeMRs}: {@code Only branches that

     * are not also filed as MRs}.
     * 
     * @return
     *     {@code Only branches that are not also filed as MRs}
     */
    public static Localizable _BranchDiscoveryTrait_excludeMRs() {
        return new Localizable(holder, "BranchDiscoveryTrait.excludeMRs");
    }

    /**
     * Key {@code GitLabSCMSource.UncategorizedCategory}: {@code Branches}.
     * 
     * @return
     *     {@code Branches}
     */
    public static String GitLabSCMSource_UncategorizedCategory() {
        return holder.format("GitLabSCMSource.UncategorizedCategory");
    }

    /**
     * Key {@code GitLabSCMSource.UncategorizedCategory}: {@code Branches}.
     * 
     * @return
     *     {@code Branches}
     */
    public static Localizable _GitLabSCMSource_UncategorizedCategory() {
        return new Localizable(holder, "GitLabSCMSource.UncategorizedCategory");
    }

    /**
     * Key {@code GitLabLink.displayName}: {@code GitLab}.
     * 
     * @return
     *     {@code GitLab}
     */
    public static String GitLabLink_displayName() {
        return holder.format("GitLabLink.displayName");
    }

    /**
     * Key {@code GitLabLink.displayName}: {@code GitLab}.
     * 
     * @return
     *     {@code GitLab}
     */
    public static Localizable _GitLabLink_displayName() {
        return new Localizable(holder, "GitLabLink.displayName");
    }

    /**
     * Key {@code BuildStatusNameCustomPartTrait.displayName}: {@code

     * Customize GitLab build status name}.
     * 
     * @return
     *     {@code Customize GitLab build status name}
     */
    public static String BuildStatusNameCustomPartTrait_displayName() {
        return holder.format("BuildStatusNameCustomPartTrait.displayName");
    }

    /**
     * Key {@code BuildStatusNameCustomPartTrait.displayName}: {@code

     * Customize GitLab build status name}.
     * 
     * @return
     *     {@code Customize GitLab build status name}
     */
    public static Localizable _BuildStatusNameCustomPartTrait_displayName() {
        return new Localizable(holder, "BuildStatusNameCustomPartTrait.displayName");
    }

    /**
     * Key {@code GitLabTagSCMHead.Pronoun}: {@code Tag}.
     * 
     * @return
     *     {@code Tag}
     */
    public static String GitLabTagSCMHead_Pronoun() {
        return holder.format("GitLabTagSCMHead.Pronoun");
    }

    /**
     * Key {@code GitLabTagSCMHead.Pronoun}: {@code Tag}.
     * 
     * @return
     *     {@code Tag}
     */
    public static Localizable _GitLabTagSCMHead_Pronoun() {
        return new Localizable(holder, "GitLabTagSCMHead.Pronoun");
    }

    /**
     * Key {@code WebhookListenerBuildConditionsTrait.displayName}: {@code

     * Webhook Listener Conditions}.
     * 
     * @return
     *     {@code Webhook Listener Conditions}
     */
    public static String WebhookListenerBuildConditionsTrait_displayName() {
        return holder.format("WebhookListenerBuildConditionsTrait.displayName");
    }

    /**
     * Key {@code WebhookListenerBuildConditionsTrait.displayName}: {@code

     * Webhook Listener Conditions}.
     * 
     * @return
     *     {@code Webhook Listener Conditions}
     */
    public static Localizable _WebhookListenerBuildConditionsTrait_displayName() {
        return new Localizable(holder, "WebhookListenerBuildConditionsTrait.displayName");
    }

    /**
     * Key {@code SubGroupProjectDiscoveryTrait.displayName}: {@code Discover

     * subgroup projects}.
     * 
     * @return
     *     {@code Discover subgroup projects}
     */
    public static String SubGroupProjectDiscoveryTrait_displayName() {
        return holder.format("SubGroupProjectDiscoveryTrait.displayName");
    }

    /**
     * Key {@code SubGroupProjectDiscoveryTrait.displayName}: {@code Discover

     * subgroup projects}.
     * 
     * @return
     *     {@code Discover subgroup projects}
     */
    public static Localizable _SubGroupProjectDiscoveryTrait_displayName() {
        return new Localizable(holder, "SubGroupProjectDiscoveryTrait.displayName");
    }

    /**
     * Key {@code HookRegistrationTrait.useItem}: {@code Use Item credentials

     * for {0} management}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Use Item credentials for {0} management}
     */
    public static String HookRegistrationTrait_useItem(Object arg0) {
        return holder.format("HookRegistrationTrait.useItem", arg0);
    }

    /**
     * Key {@code HookRegistrationTrait.useItem}: {@code Use Item credentials

     * for {0} management}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Use Item credentials for {0} management}
     */
    public static Localizable _HookRegistrationTrait_useItem(Object arg0) {
        return new Localizable(holder, "HookRegistrationTrait.useItem", arg0);
    }

    /**
     * Key {@code SSHCheckoutTrait.incompatibleCredentials}: {@code The

     * currently configured credentials are incompatible with this

     * behaviour}.
     * 
     * @return
     *     {@code The currently configured credentials are incompatible with this

     *     behaviour}
     */
    public static String SSHCheckoutTrait_incompatibleCredentials() {
        return holder.format("SSHCheckoutTrait.incompatibleCredentials");
    }

    /**
     * Key {@code SSHCheckoutTrait.incompatibleCredentials}: {@code The

     * currently configured credentials are incompatible with this

     * behaviour}.
     * 
     * @return
     *     {@code The currently configured credentials are incompatible with this

     *     behaviour}
     */
    public static Localizable _SSHCheckoutTrait_incompatibleCredentials() {
        return new Localizable(holder, "SSHCheckoutTrait.incompatibleCredentials");
    }

    /**
     * Key {@code ExcludeArchivedRepositoriesTrait.displayName}: {@code

     * Exclude archived repositories}.
     * 
     * @return
     *     {@code Exclude archived repositories}
     */
    public static String ExcludeArchivedRepositoriesTrait_displayName() {
        return holder.format("ExcludeArchivedRepositoriesTrait.displayName");
    }

    /**
     * Key {@code ExcludeArchivedRepositoriesTrait.displayName}: {@code

     * Exclude archived repositories}.
     * 
     * @return
     *     {@code Exclude archived repositories}
     */
    public static Localizable _ExcludeArchivedRepositoriesTrait_displayName() {
        return new Localizable(holder, "ExcludeArchivedRepositoriesTrait.displayName");
    }

    /**
     * Key {@code GitLabSCMNavigator.pronoun}: {@code GitLab Group}.
     * 
     * @return
     *     {@code GitLab Group}
     */
    public static String GitLabSCMNavigator_pronoun() {
        return holder.format("GitLabSCMNavigator.pronoun");
    }

    /**
     * Key {@code GitLabSCMNavigator.pronoun}: {@code GitLab Group}.
     * 
     * @return
     *     {@code GitLab Group}
     */
    public static Localizable _GitLabSCMNavigator_pronoun() {
        return new Localizable(holder, "GitLabSCMNavigator.pronoun");
    }

    /**
     * Key {@code ProjectNamingStrategyTrait.fullProjectPath}: {@code Full

     * Project Path}.
     * 
     * @return
     *     {@code Full Project Path}
     */
    public static String ProjectNamingStrategyTrait_fullProjectPath() {
        return holder.format("ProjectNamingStrategyTrait.fullProjectPath");
    }

    /**
     * Key {@code ProjectNamingStrategyTrait.fullProjectPath}: {@code Full

     * Project Path}.
     * 
     * @return
     *     {@code Full Project Path}
     */
    public static Localizable _ProjectNamingStrategyTrait_fullProjectPath() {
        return new Localizable(holder, "ProjectNamingStrategyTrait.fullProjectPath");
    }

    /**
     * Key {@code GitLabWebHookCause.ShortDescription.MergeRequestHook}:

     * {@code Triggered by GitLab Merge Request #{0}: {1} => {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Triggered by GitLab Merge Request #{0}: {1} => {2}}
     */
    public static String GitLabWebHookCause_ShortDescription_MergeRequestHook(Object arg0, Object arg1, Object arg2) {
        return holder.format("GitLabWebHookCause.ShortDescription.MergeRequestHook", arg0, arg1, arg2);
    }

    /**
     * Key {@code GitLabWebHookCause.ShortDescription.MergeRequestHook}:

     * {@code Triggered by GitLab Merge Request #{0}: {1} => {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Triggered by GitLab Merge Request #{0}: {1} => {2}}
     */
    public static Localizable _GitLabWebHookCause_ShortDescription_MergeRequestHook(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "GitLabWebHookCause.ShortDescription.MergeRequestHook", arg0, arg1, arg2);
    }

    /**
     * Key {@code HookRegistrationTrait.displayName}: {@code Override GitLab

     * hook management modes}.
     * 
     * @return
     *     {@code Override GitLab hook management modes}
     */
    public static String HookRegistrationTrait_displayName() {
        return holder.format("HookRegistrationTrait.displayName");
    }

    /**
     * Key {@code HookRegistrationTrait.displayName}: {@code Override GitLab

     * hook management modes}.
     * 
     * @return
     *     {@code Override GitLab hook management modes}
     */
    public static Localizable _HookRegistrationTrait_displayName() {
        return new Localizable(holder, "HookRegistrationTrait.displayName");
    }

    /**
     * Key {@code BranchSCMHead.Pronoun}: {@code Branch}.
     * 
     * @return
     *     {@code Branch}
     */
    public static String BranchSCMHead_Pronoun() {
        return holder.format("BranchSCMHead.Pronoun");
    }

    /**
     * Key {@code BranchSCMHead.Pronoun}: {@code Branch}.
     * 
     * @return
     *     {@code Branch}
     */
    public static Localizable _BranchSCMHead_Pronoun() {
        return new Localizable(holder, "BranchSCMHead.Pronoun");
    }

}
