// CHECKSTYLE:OFF

package io.jenkins.plugins.gitlabserverconfig.credentials;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code PersonalAccessTokenImpl.tokenRequired}: {@code Token

     * required}.
     * 
     * @return
     *     {@code Token required}
     */
    public static String PersonalAccessTokenImpl_tokenRequired() {
        return holder.format("PersonalAccessTokenImpl.tokenRequired");
    }

    /**
     * Key {@code PersonalAccessTokenImpl.tokenRequired}: {@code Token

     * required}.
     * 
     * @return
     *     {@code Token required}
     */
    public static Localizable _PersonalAccessTokenImpl_tokenRequired() {
        return new Localizable(holder, "PersonalAccessTokenImpl.tokenRequired");
    }

    /**
     * Key {@code GroupAccessTokenImpl.displayName}: {@code GitLab Group

     * Access Token}.
     * 
     * @return
     *     {@code GitLab Group Access Token}
     */
    public static String GroupAccessTokenImpl_displayName() {
        return holder.format("GroupAccessTokenImpl.displayName");
    }

    /**
     * Key {@code GroupAccessTokenImpl.displayName}: {@code GitLab Group

     * Access Token}.
     * 
     * @return
     *     {@code GitLab Group Access Token}
     */
    public static Localizable _GroupAccessTokenImpl_displayName() {
        return new Localizable(holder, "GroupAccessTokenImpl.displayName");
    }

    /**
     * Key {@code PersonalAccessTokenImpl.tokenWrongLength}: {@code Token

     * should be at least 20 characters long}.
     * 
     * @return
     *     {@code Token should be at least 20 characters long}
     */
    public static String PersonalAccessTokenImpl_tokenWrongLength() {
        return holder.format("PersonalAccessTokenImpl.tokenWrongLength");
    }

    /**
     * Key {@code PersonalAccessTokenImpl.tokenWrongLength}: {@code Token

     * should be at least 20 characters long}.
     * 
     * @return
     *     {@code Token should be at least 20 characters long}
     */
    public static Localizable _PersonalAccessTokenImpl_tokenWrongLength() {
        return new Localizable(holder, "PersonalAccessTokenImpl.tokenWrongLength");
    }

    /**
     * Key {@code GroupAccessTokenImpl.tokenRequired}: {@code Token

     * required}.
     * 
     * @return
     *     {@code Token required}
     */
    public static String GroupAccessTokenImpl_tokenRequired() {
        return holder.format("GroupAccessTokenImpl.tokenRequired");
    }

    /**
     * Key {@code GroupAccessTokenImpl.tokenRequired}: {@code Token

     * required}.
     * 
     * @return
     *     {@code Token required}
     */
    public static Localizable _GroupAccessTokenImpl_tokenRequired() {
        return new Localizable(holder, "GroupAccessTokenImpl.tokenRequired");
    }

    /**
     * Key {@code PersonalAccessTokenImpl.displayName}: {@code GitLab

     * Personal Access Token}.
     * 
     * @return
     *     {@code GitLab Personal Access Token}
     */
    public static String PersonalAccessTokenImpl_displayName() {
        return holder.format("PersonalAccessTokenImpl.displayName");
    }

    /**
     * Key {@code PersonalAccessTokenImpl.displayName}: {@code GitLab

     * Personal Access Token}.
     * 
     * @return
     *     {@code GitLab Personal Access Token}
     */
    public static Localizable _PersonalAccessTokenImpl_displayName() {
        return new Localizable(holder, "PersonalAccessTokenImpl.displayName");
    }

    /**
     * Key {@code GroupAccessTokenImpl.tokenWrongLength}: {@code Token should

     * be at least 20 characters long}.
     * 
     * @return
     *     {@code Token should be at least 20 characters long}
     */
    public static String GroupAccessTokenImpl_tokenWrongLength() {
        return holder.format("GroupAccessTokenImpl.tokenWrongLength");
    }

    /**
     * Key {@code GroupAccessTokenImpl.tokenWrongLength}: {@code Token should

     * be at least 20 characters long}.
     * 
     * @return
     *     {@code Token should be at least 20 characters long}
     */
    public static Localizable _GroupAccessTokenImpl_tokenWrongLength() {
        return new Localizable(holder, "GroupAccessTokenImpl.tokenWrongLength");
    }

}
