/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.github;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import jenkins.triggers.SCMTriggerItem;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMRevision;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class SCMFacade {
    @CheckForNull
    public SCMSource findSCMSource(Job<?, ?> job) {
        return SCMSource.SourceByItem.findSource(job);
    }

    public Optional<GitHubSCMSource> findGitHubSCMSource(Job<?, ?> job) {
        SCMSource source = this.findSCMSource(job);
        return source instanceof GitHubSCMSource ? Optional.of((GitHubSCMSource)source) : Optional.empty();
    }

    public Optional<GitSCMSource> findGitSCMSource(Job<?, ?> job) {
        SCMSource source = this.findSCMSource(job);
        return source instanceof GitSCMSource ? Optional.of((GitSCMSource)source) : Optional.empty();
    }

    public Optional<GitSCM> findGitSCM(Run<?, ?> run) {
        SCM scm = this.getScm(run);
        return this.toGitScm(scm);
    }

    public Optional<GitSCM> findGitSCM(Job<?, ?> job) {
        SCM scm = this.getScm(job);
        return this.toGitScm(scm);
    }

    private Optional<GitSCM> toGitScm(SCM scm) {
        if (scm instanceof GitSCM) {
            return Optional.of((GitSCM)scm);
        }
        return Optional.empty();
    }

    UserRemoteConfig getUserRemoteConfig(GitSCM scm) {
        List configs = scm.getUserRemoteConfigs();
        if (configs.isEmpty()) {
            return new UserRemoteConfig(null, null, null, null);
        }
        return (UserRemoteConfig)configs.get(0);
    }

    public Optional<StandardUsernameCredentials> findGitHubAppCredentials(Job<?, ?> job, String credentialsId) {
        Optional<GitHubSCMSource> source = this.findGitHubSCMSource(job);
        String apiUri = source.map(GitHubSCMSource::getApiUri).orElse(null);
        String owner = source.map(GitHubSCMSource::getRepoOwner).orElse(null);
        StandardCredentials appCredentials = Connector.lookupScanCredentials(job, (String)apiUri, (String)credentialsId, (String)owner);
        return Optional.ofNullable(appCredentials).filter(StandardUsernameCredentials.class::isInstance).map(StandardUsernameCredentials.class::cast);
    }

    public Optional<SCMHead> findHead(Job<?, ?> job) {
        SCMHead head = SCMHead.HeadByItem.findHead(job);
        return Optional.ofNullable(head);
    }

    public Optional<SCMRevision> findRevision(SCMSource source, SCMHead head) {
        try {
            return Optional.ofNullable(source.fetch(head, null));
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(String.format("Could not fetch revision from repository: %s and branch: %s", source.getId(), head.getName()), e);
        }
    }

    public Optional<SCMRevision> findRevision(GitHubSCMSource source, Run<?, ?> run) {
        return Optional.ofNullable(SCMRevisionAction.getRevision((SCMSource)source, run));
    }

    public Optional<String> findHash(SCMRevision revision) {
        if (revision instanceof AbstractGitSCMSource.SCMRevisionImpl) {
            return Optional.of(((AbstractGitSCMSource.SCMRevisionImpl)revision).getHash());
        }
        if (revision instanceof PullRequestSCMRevision) {
            return Optional.of(((PullRequestSCMRevision)revision).getPullHash());
        }
        return Optional.empty();
    }

    public SCM getScm(Run<?, ?> run) {
        return this.getScm(run.getParent());
    }

    public SCM getScm(Job<?, ?> job) {
        if (job instanceof AbstractProject) {
            return this.extractFromProject((AbstractProject)job);
        }
        if (job instanceof SCMTriggerItem) {
            return this.extractFromPipeline(job);
        }
        return new NullSCM();
    }

    private SCM extractFromPipeline(Job<?, ?> job) {
        FlowDefinition definition;
        Collection scms = ((SCMTriggerItem)job).getSCMs();
        if (!scms.isEmpty()) {
            return (SCM)scms.iterator().next();
        }
        if (job instanceof WorkflowJob && (definition = ((WorkflowJob)job).getDefinition()) instanceof CpsScmFlowDefinition) {
            return ((CpsScmFlowDefinition)definition).getScm();
        }
        return new NullSCM();
    }

    private SCM extractFromProject(AbstractProject<?, ?> job) {
        if (job.getScm() != null) {
            return job.getScm();
        }
        SCM scm = job.getRootProject().getScm();
        if (scm != null) {
            return scm;
        }
        return new NullSCM();
    }
}

