/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.github;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import edu.hm.hafner.util.VisibleForTesting;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksPublisher;
import io.jenkins.plugins.checks.github.GitHubChecksContext;
import io.jenkins.plugins.checks.github.GitHubChecksDetails;
import io.jenkins.plugins.util.PluginLogger;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubAppCredentials;
import org.kohsuke.github.GHCheckRun;
import org.kohsuke.github.GHCheckRunBuilder;
import org.kohsuke.github.GitHub;

public class GitHubChecksPublisher
extends ChecksPublisher {
    private static final String GITHUB_URL = "https://api.github.com";
    private static final Logger SYSTEM_LOGGER = Logger.getLogger(GitHubChecksPublisher.class.getName());
    private final GitHubChecksContext context;
    private final PluginLogger buildLogger;
    private final String gitHubUrl;

    public GitHubChecksPublisher(GitHubChecksContext context, PluginLogger buildLogger) {
        this(context, buildLogger, GITHUB_URL);
    }

    GitHubChecksPublisher(GitHubChecksContext context, PluginLogger buildLogger, String gitHubUrl) {
        this.context = context;
        this.buildLogger = buildLogger;
        this.gitHubUrl = gitHubUrl;
    }

    public void publish(ChecksDetails details) {
        try {
            StandardUsernameCredentials credentials = this.context.getCredentials();
            switch (credentials.getClass().getSimpleName()) {
                case "GitHubAppCredentials": 
                case "VaultUsernamePasswordCredentialImpl": {
                    break;
                }
                default: {
                    return;
                }
            }
            String apiUri = null;
            if (credentials instanceof GitHubAppCredentials) {
                apiUri = ((GitHubAppCredentials)credentials).getApiUri();
            }
            GitHub gitHub = Connector.connect((String)((String)StringUtils.defaultIfBlank((CharSequence)apiUri, (CharSequence)this.gitHubUrl)), (StandardCredentials)credentials);
            GitHubChecksDetails gitHubDetails = new GitHubChecksDetails(details);
            Optional<Long> existingId = this.context.getId(gitHubDetails.getName());
            GHCheckRun run = existingId.isPresent() ? this.getUpdater(gitHub, gitHubDetails, existingId.get()).create() : this.getCreator(gitHub, gitHubDetails).create();
            this.context.addActionIfMissing(run.getId(), gitHubDetails.getName());
            this.buildLogger.log("GitHub check (name: %s, status: %s) has been published.", new Object[]{gitHubDetails.getName(), gitHubDetails.getStatus()});
            SYSTEM_LOGGER.fine(String.format("Published check for repo: %s, sha: %s, job name: %s, name: %s, status: %s", this.context.getRepository(), this.context.getHeadSha(), this.context.getJob().getFullName(), gitHubDetails.getName(), gitHubDetails.getStatus()).replaceAll("[\r\n]", ""));
        }
        catch (IOException e) {
            String message = "Failed Publishing GitHub checks: ";
            SYSTEM_LOGGER.log(Level.WARNING, (message + String.valueOf(details)).replaceAll("[\r\n]", ""), e);
            this.buildLogger.log("%s", new Object[]{message + String.valueOf(e)});
        }
    }

    @VisibleForTesting
    GHCheckRunBuilder getUpdater(GitHub github, GitHubChecksDetails details, long checkId) throws IOException {
        GHCheckRunBuilder builder = github.getRepository(this.context.getRepository()).updateCheckRun(checkId);
        return this.applyDetails(builder, details);
    }

    @VisibleForTesting
    GHCheckRunBuilder getCreator(GitHub gitHub, GitHubChecksDetails details) throws IOException {
        GHCheckRunBuilder builder = gitHub.getRepository(this.context.getRepository()).createCheckRun(details.getName(), this.context.getHeadSha()).withStartedAt(details.getStartedAt().orElse(Date.from(Instant.now())));
        return this.applyDetails(builder, details);
    }

    @VisibleForTesting
    GitHubChecksContext getContext() {
        return this.context;
    }

    private GHCheckRunBuilder applyDetails(GHCheckRunBuilder builder, GitHubChecksDetails details) {
        builder.withStatus(details.getStatus()).withDetailsURL(details.getDetailsURL().orElse(this.context.getURL()));
        if (this.context.getRun().isPresent()) {
            String externalId = this.context.getRun().get().getExternalizableId();
            builder.withExternalID(externalId);
        }
        if (details.getConclusion().isPresent()) {
            builder.withConclusion(details.getConclusion().get()).withCompletedAt(details.getCompletedAt().orElse(Date.from(Instant.now())));
        }
        details.getOutput().ifPresent(arg_0 -> ((GHCheckRunBuilder)builder).add(arg_0));
        details.getActions().forEach(arg_0 -> ((GHCheckRunBuilder)builder).add(arg_0));
        return builder;
    }
}

