/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.github.status;

import hudson.Extension;
import hudson.util.FormValidation;
import io.jenkins.plugins.checks.github.status.GitHubStatusChecksConfigurations;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Discovery;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GitHubSCMSourceStatusChecksTrait
extends SCMSourceTrait
implements GitHubStatusChecksConfigurations {
    private boolean skip = false;
    private boolean skipNotifications = false;
    private boolean unstableBuildNeutral = false;
    private String name = "Jenkins";
    private boolean suppressLogs = false;
    private boolean skipProgressUpdates = false;

    @DataBoundConstructor
    public GitHubSCMSourceStatusChecksTrait() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSkip() {
        return this.skip;
    }

    @Override
    public boolean isUnstableBuildNeutral() {
        return this.unstableBuildNeutral;
    }

    public boolean isSkipNotifications() {
        return this.skipNotifications;
    }

    @Override
    public boolean isSuppressLogs() {
        return this.suppressLogs;
    }

    @Override
    public boolean isSkipProgressUpdates() {
        return this.skipProgressUpdates;
    }

    @DataBoundSetter
    public void setSkipProgressUpdates(boolean skipProgressUpdates) {
        this.skipProgressUpdates = skipProgressUpdates;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    @DataBoundSetter
    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    @DataBoundSetter
    public void setUnstableBuildNeutral(boolean unstableBuildNeutral) {
        this.unstableBuildNeutral = unstableBuildNeutral;
    }

    @DataBoundSetter
    public void setSkipNotifications(boolean skipNotifications) {
        this.skipNotifications = skipNotifications;
    }

    @DataBoundSetter
    public void setSuppressLogs(boolean suppressLogs) {
        this.suppressLogs = suppressLogs;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        if (this.isSkipNotifications() && context instanceof GitHubSCMSourceContext) {
            ((GitHubSCMSourceContext)context).withNotificationsDisabled(true);
        }
    }

    @Symbol(value={"gitHubStatusChecks"})
    @Extension
    @Discovery
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return "Status Checks Properties";
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitHubSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GitHubSCMSource.class;
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if (StringUtils.isBlank((CharSequence)name)) {
                return FormValidation.error((String)"Name should not be empty!");
            }
            return FormValidation.ok();
        }
    }
}

