/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.github;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import io.jenkins.plugins.checks.api.ChecksPublisher;
import io.jenkins.plugins.checks.api.ChecksPublisherFactory;
import io.jenkins.plugins.checks.github.GitHubChecksContext;
import io.jenkins.plugins.checks.github.GitHubChecksPublisher;
import io.jenkins.plugins.checks.github.GitHubSCMSourceChecksContext;
import io.jenkins.plugins.checks.github.GitSCMChecksContext;
import io.jenkins.plugins.checks.github.SCMFacade;
import io.jenkins.plugins.checks.github.config.DefaultGitHubChecksConfig;
import io.jenkins.plugins.checks.github.config.GitHubChecksConfig;
import io.jenkins.plugins.util.PluginLogger;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;

@Extension
public class GitHubChecksPublisherFactory
extends ChecksPublisherFactory {
    private final SCMFacade scmFacade;
    private final DisplayURLProvider urlProvider;

    public GitHubChecksPublisherFactory() {
        this(new SCMFacade(), DisplayURLProvider.get());
    }

    @VisibleForTesting
    GitHubChecksPublisherFactory(SCMFacade scmFacade, DisplayURLProvider urlProvider) {
        this.scmFacade = scmFacade;
        this.urlProvider = urlProvider;
    }

    protected Optional<ChecksPublisher> createPublisher(Run<?, ?> run, TaskListener listener) {
        String runURL = this.urlProvider.getRunURL(run);
        return this.createPublisher(listener, this.getChecksConfig(run.getParent()), GitHubSCMSourceChecksContext.fromRun(run, runURL, this.scmFacade), new GitSCMChecksContext(run, runURL, this.scmFacade));
    }

    protected Optional<ChecksPublisher> createPublisher(Job<?, ?> job, TaskListener listener) {
        return this.createPublisher(listener, this.getChecksConfig(job), GitHubSCMSourceChecksContext.fromJob(job, this.urlProvider.getJobURL(job), this.scmFacade));
    }

    private Optional<ChecksPublisher> createPublisher(TaskListener listener, GitHubChecksConfig config, GitHubChecksContext ... contexts) {
        FilteredLog causeLogger = new FilteredLog("Causes for no suitable publisher found: ");
        PluginLogger consoleLogger = new PluginLogger(listener.getLogger(), "GitHub Checks");
        for (GitHubChecksContext ctx : contexts) {
            if (!ctx.isValid(causeLogger)) continue;
            return Optional.of(new GitHubChecksPublisher(ctx, consoleLogger));
        }
        if (config.isVerboseConsoleLog()) {
            consoleLogger.logEachLine((Collection)causeLogger.getErrorMessages());
        }
        return Optional.empty();
    }

    private GitHubChecksConfig getChecksConfig(Job<?, ?> job) {
        Optional<GitHubSCMSource> gitHubSCMSource = this.scmFacade.findGitHubSCMSource(job);
        if (gitHubSCMSource.isPresent()) {
            return this.getChecksConfig(gitHubSCMSource.get().getTraits().stream()).orElseGet(DefaultGitHubChecksConfig::new);
        }
        Optional<GitSCM> gitSCM = this.scmFacade.findGitSCM(job);
        return gitSCM.map(scm -> this.getChecksConfig(scm.getExtensions().stream()).orElse(new DefaultGitHubChecksConfig())).orElseGet(DefaultGitHubChecksConfig::new);
    }

    private Optional<GitHubChecksConfig> getChecksConfig(Stream<?> stream) {
        return stream.filter(t -> t instanceof GitHubChecksConfig).findFirst().map(t -> (GitHubChecksConfig)t);
    }
}

