/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.github;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.checks.github.GitHubChecksAction;
import io.jenkins.plugins.checks.github.SCMFacade;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public abstract class GitHubChecksContext {
    private final Job<?, ?> job;
    private final String url;
    private final SCMFacade scmFacade;

    protected GitHubChecksContext(Job<?, ?> job, String url, SCMFacade scmFacade) {
        this.job = job;
        this.url = url;
        this.scmFacade = scmFacade;
    }

    public abstract String getHeadSha();

    public abstract String getRepository();

    public abstract boolean isValid(FilteredLog var1);

    @CheckForNull
    protected abstract String getCredentialsId();

    public StandardUsernameCredentials getCredentials() {
        return this.getGitHubAppCredentials((String)StringUtils.defaultIfEmpty((CharSequence)this.getCredentialsId(), (CharSequence)""));
    }

    public String getURL() {
        return this.url;
    }

    protected Job<?, ?> getJob() {
        return this.job;
    }

    protected final SCMFacade getScmFacade() {
        return this.scmFacade;
    }

    protected StandardUsernameCredentials getGitHubAppCredentials(String credentialsId) {
        return this.findGitHubAppCredentials(credentialsId).orElseThrow(() -> new IllegalStateException("No GitHub APP credentials available for job: " + this.getJob().getName()));
    }

    protected boolean hasGitHubAppCredentials() {
        return this.findGitHubAppCredentials((String)StringUtils.defaultIfEmpty((CharSequence)this.getCredentialsId(), (CharSequence)"")).isPresent();
    }

    protected boolean hasCredentialsId() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.getCredentialsId()});
    }

    protected boolean hasValidCredentials(FilteredLog logger) {
        if (!this.hasCredentialsId()) {
            logger.logError("No credentials found");
            return false;
        }
        if (!this.hasGitHubAppCredentials()) {
            logger.logError("No GitHub app credentials found: '%s'", new Object[]{this.getCredentialsId()});
            logger.logError("See: https://github.com/jenkinsci/github-branch-source-plugin/blob/master/docs/github-app.adoc");
            return false;
        }
        return true;
    }

    private Optional<StandardUsernameCredentials> findGitHubAppCredentials(String credentialsId) {
        return this.getScmFacade().findGitHubAppCredentials(this.getJob(), credentialsId);
    }

    public Optional<Long> getId(String name) {
        return this.getAction(name).map(GitHubChecksAction::getId);
    }

    protected abstract Optional<Run<?, ?>> getRun();

    private Optional<GitHubChecksAction> getAction(String name) {
        if (this.getRun().isEmpty()) {
            return Optional.empty();
        }
        return this.getRun().get().getActions(GitHubChecksAction.class).stream().filter(a -> a.getName().equals(name)).findFirst();
    }

    void addActionIfMissing(long id, String name) {
        if (this.getRun().isEmpty()) {
            return;
        }
        Optional<GitHubChecksAction> action = this.getAction(name);
        if (action.isEmpty()) {
            this.getRun().get().addAction((Action)new GitHubChecksAction(id, name));
        }
    }
}

