/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitversionmonitor;

import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public record GitVersion(Integer major, Integer minor, Integer patch, Integer build) {
    private static final Logger LOG = LoggerFactory.getLogger(GitVersion.class);

    public static GitVersion of(Integer major, Integer minor, Integer patch, Integer build) {
        return new GitVersion(major, minor, patch, build);
    }

    public static @Nullable GitVersion parse(@Nullable String version) {
        if (version == null || version.isEmpty()) {
            return null;
        }
        try {
            String build;
            String[] parts = version.replace("git version", "").replace(".windows", "").replaceAll("\\(.*\\)", "").replace(" ", "").trim().split("\\.");
            String major = parts.length > 0 ? parts[0] : "0";
            String minor = parts.length > 1 ? parts[1] : "0";
            String patch = parts.length > 2 ? parts[2] : "0";
            String string = build = parts.length > 3 ? parts[3] : "0";
            if (!(major.matches("\\d+") && minor.matches("\\d+") && patch.matches("\\d+") && build.matches("\\d+"))) {
                LOG.warn("Invalid version format: {}", (Object)version);
                return null;
            }
            return new GitVersion(Integer.parseInt(major), Integer.parseInt(minor), Integer.parseInt(patch), Integer.parseInt(build));
        }
        catch (Exception e) {
            LOG.error("Failed to parse Git version: {}", (Object)version, (Object)e);
            return null;
        }
    }

    @Override
    public String toString() {
        if (this.build != 0) {
            return "%d.%d.%d.%d".formatted(this.major, this.minor, this.patch, this.build);
        }
        return "%d.%d.%d".formatted(this.major, this.minor, this.patch);
    }
}

