/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitversionmonitor;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.node_monitors.AbstractAsyncNodeMonitorDescriptor;
import hudson.node_monitors.NodeMonitor;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.StreamTaskListener;
import io.jenkins.plugins.gitversionmonitor.GitVersion;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import jenkins.MasterToSlaveFileCallable;
import org.jenkinsci.Symbol;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class GitVersionNodeMonitor
extends NodeMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(GitVersionNodeMonitor.class);

    @DataBoundConstructor
    public GitVersionNodeMonitor() {
    }

    public String toHtml(@Nullable String version) {
        GitVersion gitVersion = GitVersion.parse(version);
        if (gitVersion == null) {
            return "N/A";
        }
        return gitVersion.toString();
    }

    private static class GetGitVersion
    extends MasterToSlaveFileCallable<String> {
        private static final Logger LOG = LoggerFactory.getLogger(GetGitVersion.class);

        private GetGitVersion() {
        }

        public @Nullable String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamTaskListener listener = new StreamTaskListener((OutputStream)out, StandardCharsets.UTF_8);
            Launcher.LocalLauncher launcher = new Launcher.LocalLauncher((TaskListener)listener);
            Launcher.ProcStarter procStarter = launcher.launch().cmds(new String[]{"git", "--version"}).stdout((OutputStream)out).stderr(null).quiet(true).pwd(f);
            Proc proc = procStarter.start();
            int exitCode = proc.join();
            String output = out.toString(StandardCharsets.UTF_8).trim();
            if (exitCode != 0) {
                LOG.warn("Failed to get Git version from {}: exit code {}, output: {}", new Object[]{f.getAbsolutePath(), exitCode, output});
                return null;
            }
            LOG.debug("Git version output: {}", (Object)output);
            GitVersion gitVersion = GitVersion.parse(output);
            if (gitVersion == null) {
                LOG.warn("Failed to parse Git version from output: {}", (Object)output);
                return null;
            }
            LOG.debug("Parsed Git version: {}", (Object)gitVersion);
            return gitVersion.toString();
        }
    }

    @Extension
    @Symbol(value={"gitVersion"})
    public static class DescriptorImpl
    extends AbstractAsyncNodeMonitorDescriptor<String> {
        protected @Nullable Callable<String, IOException> createCallable(Computer computer) {
            Node node = computer.getNode();
            if (node == null) {
                LOG.warn("Node is null for computer: {}", (Object)computer.getName());
                return null;
            }
            FilePath filePath = node.getRootPath();
            if (filePath == null) {
                LOG.warn("Root path is null for node: {}", (Object)node.getNodeName());
                return null;
            }
            return filePath.asCallableWith((FilePath.FileCallable)new GetGitVersion());
        }

        @NonNull
        public String getDisplayName() {
            return "Git Version";
        }
    }
}

