// CHECKSTYLE:OFF

package io.jenkins.plugins.forensics.git.reference;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code No.Reference.Build}: {@code no reference build found}.
     * 
     * @return
     *     {@code no reference build found}
     */
    public static String No_Reference_Build() {
        return holder.format("No.Reference.Build");
    }

    /**
     * Key {@code No.Reference.Build}: {@code no reference build found}.
     * 
     * @return
     *     {@code no reference build found}
     */
    public static Localizable _No_Reference_Build() {
        return new Localizable(holder, "No.Reference.Build");
    }

    /**
     * Key {@code FieldValidator.Error.ReferenceJobDoesNotExist}: {@code
     * There is no such job - maybe the job has been renamed?}.
     * 
     * @return
     *     {@code There is no such job - maybe the job has been renamed?}
     */
    public static String FieldValidator_Error_ReferenceJobDoesNotExist() {
        return holder.format("FieldValidator.Error.ReferenceJobDoesNotExist");
    }

    /**
     * Key {@code FieldValidator.Error.ReferenceJobDoesNotExist}: {@code
     * There is no such job - maybe the job has been renamed?}.
     * 
     * @return
     *     {@code There is no such job - maybe the job has been renamed?}
     */
    public static Localizable _FieldValidator_Error_ReferenceJobDoesNotExist() {
        return new Localizable(holder, "FieldValidator.Error.ReferenceJobDoesNotExist");
    }

    /**
     * Key {@code Recorder.DisplayName}: {@code Discover Git reference
     * build}.
     * 
     * @return
     *     {@code Discover Git reference build}
     */
    public static String Recorder_DisplayName() {
        return holder.format("Recorder.DisplayName");
    }

    /**
     * Key {@code Recorder.DisplayName}: {@code Discover Git reference
     * build}.
     * 
     * @return
     *     {@code Discover Git reference build}
     */
    public static Localizable _Recorder_DisplayName() {
        return new Localizable(holder, "Recorder.DisplayName");
    }

    /**
     * Key {@code Action.DisplayName}: {@code Commits}.
     * 
     * @return
     *     {@code Commits}
     */
    public static String Action_DisplayName() {
        return holder.format("Action.DisplayName");
    }

    /**
     * Key {@code Action.DisplayName}: {@code Commits}.
     * 
     * @return
     *     {@code Commits}
     */
    public static Localizable _Action_DisplayName() {
        return new Localizable(holder, "Action.DisplayName");
    }

}
