/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.util;

import hudson.plugins.git.browser.GitRepositoryBrowser;
import io.jenkins.plugins.forensics.git.util.GitCommitTextDecorator;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class GitCommitDecorator
extends GitCommitTextDecorator {
    private final GitRepositoryBrowser browser;

    GitCommitDecorator(GitRepositoryBrowser browser) {
        this.browser = browser;
    }

    @Override
    public String asLink(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return this.createLink(id).orElse(this.asText(id));
        }
        return id;
    }

    private Optional<String> createLink(String id) {
        try {
            URL link = this.browser.getChangeSetLink(id);
            if (link != null) {
                return Optional.of(((ContainerTag)TagCreator.a().withText(this.asText(id)).withHref(link.toString())).render());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

