/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.miner;

import edu.hm.hafner.util.FilteredLog;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import one.util.streamex.StreamEx;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

class CommitCollector {
    CommitCollector() {
    }

    List<RevCommit> findAllCommits(Repository repository, Git git, String latestCommitId, FilteredLog logger) throws IOException, GitAPIException {
        ObjectId head = repository.resolve("HEAD");
        if (head == null) {
            logger.logError("No HEAD commit found in " + String.valueOf(repository));
            return Collections.emptyList();
        }
        Iterator commits = git.log().add((AnyObjectId)head).call().iterator();
        return ((StreamEx)StreamEx.of(commits).takeWhile(commit -> !latestCommitId.equals(commit.getName()))).toList();
    }
}

