/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.reference;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Run;
import io.jenkins.plugins.forensics.git.reference.GitCommitsRecord;
import io.jenkins.plugins.forensics.git.reference.Messages;
import io.jenkins.plugins.forensics.reference.ReferenceRecorder;
import io.jenkins.plugins.forensics.reference.SimpleReferenceRecorder;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.Optional;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GitReferenceRecorder
extends ReferenceRecorder {
    private int maxCommits = 100;
    private boolean skipUnknownCommits = false;

    @DataBoundConstructor
    public GitReferenceRecorder() {
        this(new JenkinsFacade());
    }

    @VisibleForTesting
    GitReferenceRecorder(JenkinsFacade jenkins) {
        super(jenkins);
    }

    @DataBoundSetter
    public void setMaxCommits(int maxCommits) {
        this.maxCommits = maxCommits;
    }

    public int getMaxCommits() {
        return this.maxCommits;
    }

    @DataBoundSetter
    public void setSkipUnknownCommits(boolean skipUnknownCommits) {
        this.skipUnknownCommits = skipUnknownCommits;
    }

    public boolean isSkipUnknownCommits() {
        return this.skipUnknownCommits;
    }

    protected Optional<Run<?, ?>> find(Run<?, ?> owner, Run<?, ?> lastCompletedBuildOfReferenceJob, FilteredLog log) {
        Optional<Object> referenceBuild;
        Optional<GitCommitsRecord> referenceCommit = GitCommitsRecord.findRecordForScm(lastCompletedBuildOfReferenceJob, this.getScm());
        if (referenceCommit.isPresent()) {
            referenceBuild = this.findByCommits(owner, referenceCommit.get(), log);
        } else {
            log.logInfo("-> selected build '%s' of reference job does not yet contain a `GitCommitsRecord`", new Object[]{lastCompletedBuildOfReferenceJob.getDisplayName()});
            referenceBuild = Optional.empty();
        }
        if (referenceBuild.isPresent()) {
            return referenceBuild;
        }
        Optional targetBranchHead = this.findTargetBranchHead(owner.getParent());
        if (targetBranchHead.isPresent()) {
            log.logInfo("-> falling back to latest build '%s' since a pull or merge request has been detected", new Object[]{lastCompletedBuildOfReferenceJob.getDisplayName()});
            return Optional.of(lastCompletedBuildOfReferenceJob);
        }
        log.logInfo("-> no reference build found");
        return Optional.empty();
    }

    private Optional<Run<?, ?>> findByCommits(Run<?, ?> owner, GitCommitsRecord referenceCommit, FilteredLog log) {
        Optional<GitCommitsRecord> ownerCommits = GitCommitsRecord.findRecordForScm(owner, this.getScm());
        if (ownerCommits.isPresent()) {
            GitCommitsRecord commitsRecord = ownerCommits.get();
            Optional<Run<?, ?>> referencePoint = commitsRecord.getReferencePoint(referenceCommit, this.getMaxCommits(), this.isSkipUnknownCommits(), log);
            if (referencePoint.isPresent()) {
                Run<?, ?> referenceBuild = referencePoint.get();
                log.logInfo("-> found build '%s' in reference job with matching commits", new Object[]{referenceBuild.getDisplayName()});
                return referencePoint;
            }
            log.logInfo("-> found no build with matching commits");
        } else {
            log.logInfo("-> found no `GitCommitsRecord` in current build '%s'", new Object[]{owner.getDisplayName()});
        }
        return Optional.empty();
    }

    @SuppressFBWarnings(value={"BC"})
    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"discoverGitReferenceBuild"})
    public static class Descriptor
    extends SimpleReferenceRecorder.SimpleReferenceRecorderDescriptor {
        public Descriptor() {
            this(new JenkinsFacade());
        }

        @VisibleForTesting
        Descriptor(JenkinsFacade jenkins) {
            super(jenkins);
        }

        @NonNull
        public String getDisplayName() {
            return Messages.Recorder_DisplayName();
        }
    }
}

