/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitcollect;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.GithubWeb;
import hudson.plugins.git.browser.Gitiles;
import hudson.plugins.git.extensions.impl.RelativeTargetDirectory;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import io.jenkins.plugins.gitcollect.GitScanner;
import io.jenkins.plugins.gitcollect.LocalGitInfo;
import io.jenkins.plugins.gitcollect.MultiScmEnvAction;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.gitclient.ChangelogCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class CollectGitStep
extends Builder
implements SimpleBuildStep {
    private static final Pattern SSH_URI_PATTERN = Pattern.compile("^ssh://(?:[^@]+@)?([^:/]+)(?::\\d+)?/(.+)$");
    private static final Pattern SCP_STYLE_PATTERN = Pattern.compile("^(?:[^@]+@)?([^:/]+):(.+)$");
    private String path;
    private String markedCommit;
    private String remote;
    private Boolean changelog = false;
    public static final Logger LOGGER = Logger.getLogger(CollectGitStep.class.getName());

    private boolean isGitRepository(GitClient git) {
        try {
            git.revListAll();
            return true;
        }
        catch (GitException | InterruptedException e) {
            return false;
        }
    }

    private static String convertToHttps(String sshUrl, boolean isGerrit) {
        if (sshUrl == null || sshUrl.isEmpty()) {
            return sshUrl;
        }
        Matcher uriMatcher = SSH_URI_PATTERN.matcher(sshUrl);
        if (uriMatcher.find()) {
            return String.format("https://%s%s/%s", uriMatcher.group(1), isGerrit ? "/plugins/gitiles" : "", uriMatcher.group(2));
        }
        Matcher scpMatcher = SCP_STYLE_PATTERN.matcher(sshUrl);
        if (scpMatcher.find()) {
            return String.format("https://%s%s/%s", scpMatcher.group(1), isGerrit ? "/plugins/gitiles" : "", scpMatcher.group(2));
        }
        return sshUrl;
    }

    private String writeChangelog(@Nonnull Run<?, ?> run, GitClient git, LocalGitInfo info) throws IOException {
        File changelogFile = null;
        changelogFile = FileSystems.getDefault().supportedFileAttributeViews().contains("posix") ? Files.createTempFile(run.getRootDir().toPath(), "changelog", ".xml", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--"))).toFile() : Files.createTempFile(run.getRootDir().toPath(), "changelog", ".xml", new FileAttribute[0]).toFile();
        if (changelogFile != null) {
            ChangelogCommand changelog = git.changelog();
            FileOutputStream stream = new FileOutputStream(changelogFile);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
            try {
                changelog.includes(info.getBuiltRevision().getSha1String()).excludes(info.getMarkedRevision().getSha1String()).to((Writer)out).execute();
            }
            catch (GitException | InterruptedException e) {
                Files.deleteIfExists(changelogFile.toPath());
                e.printStackTrace();
            }
            return changelogFile.getAbsolutePath();
        }
        return null;
    }

    private GitSCM perfromAgainstWorkflowRun(WorkflowRun run, FilePath gitDir, FilePath workspace, TaskListener listener, String url, String changeLogPath) throws IOException, Exception {
        WorkflowRun.SCMListenerImpl scmListenerImpl = new WorkflowRun.SCMListenerImpl();
        GitSCM scm = new GitSCM(url);
        scm.getExtensions().add((Object)new RelativeTargetDirectory(gitDir.getRemote()));
        Object browser = (GitRepositoryBrowser)scm.guessBrowser();
        if (browser == null) {
            browser = url.contains("gerrit") ? new Gitiles(CollectGitStep.convertToHttps(url, true)) : new GithubWeb(CollectGitStep.convertToHttps(url, false));
        }
        scm.setBrowser(browser);
        scmListenerImpl.onCheckout((Run)run, (SCM)scm, workspace, listener, new File(changeLogPath), null);
        return scm;
    }

    @DataBoundConstructor
    public CollectGitStep() {
    }

    @DataBoundSetter
    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    @DataBoundSetter
    public void setChangelog(boolean changelog) {
        this.changelog = changelog;
    }

    public Boolean getChangelog() {
        return this.changelog;
    }

    @DataBoundSetter
    public void setRemote(String remote) {
        this.remote = remote;
    }

    public String getRemote() {
        if (this.remote == null || this.remote.isEmpty()) {
            return "origin";
        }
        return this.remote;
    }

    @DataBoundSetter
    public void setMarkedCommit(String markedCommit) {
        this.markedCommit = markedCommit;
    }

    public String getMarkedCommit() {
        return this.markedCommit;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        String path;
        FilePath gitDir;
        FilePath filePath = gitDir = this.path == null || this.path.trim().isEmpty() ? workspace : workspace.child(this.path);
        if (!gitDir.exists()) {
            throw new IOException("[GitCollect] Error: Path not found: " + gitDir.getRemote());
        }
        EnvVars env = run.getEnvironment(listener);
        GitClient git = Git.with((TaskListener)listener, (EnvVars)env).in(gitDir).getClient();
        if (!this.isGitRepository(git)) {
            throw new IOException("[GitCollect] Error: The directory '" + gitDir.getRemote() + "' is not a valid Git repository.");
        }
        String targetStr = this.markedCommit != null && !this.markedCommit.trim().isEmpty() ? this.markedCommit : "HEAD";
        LOGGER.log(Level.FINE, "Analyzing repository at: " + gitDir.getRemote());
        LocalGitInfo info = (LocalGitInfo)workspace.act((FilePath.FileCallable)new GitScanner(git, this.markedCommit, this.getRemote()));
        LOGGER.log(Level.FINE, "url: " + info.getRemoteUrl() + " branch: " + info.getBranch());
        Result result = run.getResult();
        if (result == null) {
            result = Result.SUCCESS;
        }
        GitSCM scm = null;
        if (this.changelog.booleanValue() && !info.getMarkedRevision().getSha1String().equals(info.getBuiltRevision().getSha1String()) && (path = this.writeChangelog(run, git, info)) != null && !path.isEmpty() && run instanceof WorkflowRun) {
            try {
                scm = this.perfromAgainstWorkflowRun((WorkflowRun)run, gitDir, workspace, listener, info.getRemoteUrl(), path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BuildData buildData = new BuildData();
        if (scm != null) {
            buildData = scm.copyBuildData(run.getPreviousBuild());
        }
        if (buildData.lastBuild != null) {
            LOGGER.log(Level.FINE, "Last Built Revision: " + String.valueOf(buildData.lastBuild.revision));
        }
        buildData.addRemoteUrl(info.getRemoteUrl());
        Build gitBuild = new Build(info.getMarkedRevision(), info.getBuiltRevision(), run.getNumber(), result);
        buildData.saveBuild(gitBuild);
        boolean buildDataAlreadyPresent = false;
        List actions = run.getActions(BuildData.class);
        for (BuildData d : actions) {
            if (!d.similarTo(buildData)) continue;
            buildDataAlreadyPresent = true;
            break;
        }
        if (!actions.isEmpty()) {
            buildData.setIndex(Integer.valueOf(actions.size() + 1));
        }
        if (!buildDataAlreadyPresent) {
            run.addAction((Action)buildData);
            run.addAction((Action)new MultiScmEnvAction(info));
        }
        LOGGER.log(Level.FINE, "BuildData attached. Marked: " + targetStr + ", Built: " + info.getShaRevision());
    }

    @Symbol(value={"collectGit"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Git Collect: Register Local Data";
        }

        @POST
        public FormValidation doCheckPath(@QueryParameter String value) {
            if (value.startsWith("/")) {
                return FormValidation.warning((String)"Paths should usually be relative to the workspace.");
            }
            return FormValidation.ok();
        }
    }
}

