/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.reference;

import edu.hm.hafner.util.FilteredLog;
import hudson.model.Run;
import io.jenkins.plugins.forensics.reference.ReferenceBuild;
import java.util.Optional;

public class ReferenceFinder {
    public Optional<Run<?, ?>> findReference(Run<?, ?> build, FilteredLog log) {
        ReferenceBuild action = (ReferenceBuild)build.getAction(ReferenceBuild.class);
        if (action == null) {
            log.logInfo("Reference build recorder is not configured");
        } else {
            log.logInfo("Obtaining reference build from reference recorder");
            Optional<Run<?, ?>> referenceBuild = action.getReferenceBuild();
            if (referenceBuild.isPresent()) {
                Run<?, ?> reference = referenceBuild.get();
                log.logInfo("-> Found '%s'", new Object[]{reference.getFullDisplayName()});
                return Optional.of(reference);
            }
            log.logInfo("-> No reference build recorded");
        }
        return Optional.empty();
    }
}

