// CHECKSTYLE:OFF

package io.jenkins.plugins.forensics.miner;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Table.Column.DeletedLines}: {@code Deleted Lines}.
     * 
     * @return
     *     {@code Deleted Lines}
     */
    public static String Table_Column_DeletedLines() {
        return holder.format("Table.Column.DeletedLines");
    }

    /**
     * Key {@code Table.Column.DeletedLines}: {@code Deleted Lines}.
     * 
     * @return
     *     {@code Deleted Lines}
     */
    public static Localizable _Table_Column_DeletedLines() {
        return new Localizable(holder, "Table.Column.DeletedLines");
    }

    /**
     * Key {@code TrendChart.Churn.Legend.Deleted}: {@code Deleted}.
     * 
     * @return
     *     {@code Deleted}
     */
    public static String TrendChart_Churn_Legend_Deleted() {
        return holder.format("TrendChart.Churn.Legend.Deleted");
    }

    /**
     * Key {@code TrendChart.Churn.Legend.Deleted}: {@code Deleted}.
     * 
     * @return
     *     {@code Deleted}
     */
    public static Localizable _TrendChart_Churn_Legend_Deleted() {
        return new Localizable(holder, "TrendChart.Churn.Legend.Deleted");
    }

    /**
     * Key {@code TrendChart.Deleted.Legend.Label}: {@code Deleted lines}.
     * 
     * @return
     *     {@code Deleted lines}
     */
    public static String TrendChart_Deleted_Legend_Label() {
        return holder.format("TrendChart.Deleted.Legend.Label");
    }

    /**
     * Key {@code TrendChart.Deleted.Legend.Label}: {@code Deleted lines}.
     * 
     * @return
     *     {@code Deleted lines}
     */
    public static Localizable _TrendChart_Deleted_Legend_Label() {
        return new Localizable(holder, "TrendChart.Deleted.Legend.Label");
    }

    /**
     * Key {@code Table.Column.File}: {@code File}.
     * 
     * @return
     *     {@code File}
     */
    public static String Table_Column_File() {
        return holder.format("Table.Column.File");
    }

    /**
     * Key {@code Table.Column.File}: {@code File}.
     * 
     * @return
     *     {@code File}
     */
    public static Localizable _Table_Column_File() {
        return new Localizable(holder, "Table.Column.File");
    }

    /**
     * Key {@code Table.Column.AddedLines}: {@code Added Lines}.
     * 
     * @return
     *     {@code Added Lines}
     */
    public static String Table_Column_AddedLines() {
        return holder.format("Table.Column.AddedLines");
    }

    /**
     * Key {@code Table.Column.AddedLines}: {@code Added Lines}.
     * 
     * @return
     *     {@code Added Lines}
     */
    public static Localizable _Table_Column_AddedLines() {
        return new Localizable(holder, "Table.Column.AddedLines");
    }

    /**
     * Key {@code TrendChart.Churn.Legend.Label}: {@code Code Churn}.
     * 
     * @return
     *     {@code Code Churn}
     */
    public static String TrendChart_Churn_Legend_Label() {
        return holder.format("TrendChart.Churn.Legend.Label");
    }

    /**
     * Key {@code TrendChart.Churn.Legend.Label}: {@code Code Churn}.
     * 
     * @return
     *     {@code Code Churn}
     */
    public static Localizable _TrendChart_Churn_Legend_Label() {
        return new Localizable(holder, "TrendChart.Churn.Legend.Label");
    }

    /**
     * Key {@code Table.Column.LastCommit}: {@code Last Commit}.
     * 
     * @return
     *     {@code Last Commit}
     */
    public static String Table_Column_LastCommit() {
        return holder.format("Table.Column.LastCommit");
    }

    /**
     * Key {@code Table.Column.LastCommit}: {@code Last Commit}.
     * 
     * @return
     *     {@code Last Commit}
     */
    public static Localizable _Table_Column_LastCommit() {
        return new Localizable(holder, "Table.Column.LastCommit");
    }

    /**
     * Key {@code TrendChart.Files.Legend.Label}: {@code #Files}.
     * 
     * @return
     *     {@code #Files}
     */
    public static String TrendChart_Files_Legend_Label() {
        return holder.format("TrendChart.Files.Legend.Label");
    }

    /**
     * Key {@code TrendChart.Files.Legend.Label}: {@code #Files}.
     * 
     * @return
     *     {@code #Files}
     */
    public static Localizable _TrendChart_Files_Legend_Label() {
        return new Localizable(holder, "TrendChart.Files.Legend.Label");
    }

    /**
     * Key {@code TrendChart.Loc.Legend.Label}: {@code #Lines Of Code}.
     * 
     * @return
     *     {@code #Lines Of Code}
     */
    public static String TrendChart_Loc_Legend_Label() {
        return holder.format("TrendChart.Loc.Legend.Label");
    }

    /**
     * Key {@code TrendChart.Loc.Legend.Label}: {@code #Lines Of Code}.
     * 
     * @return
     *     {@code #Lines Of Code}
     */
    public static Localizable _TrendChart_Loc_Legend_Label() {
        return new Localizable(holder, "TrendChart.Loc.Legend.Label");
    }

    /**
     * Key {@code ForensicsView.Title}: {@code SCM Forensics of ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code SCM Forensics of ''{0}''}
     */
    public static String ForensicsView_Title(Object arg0) {
        return holder.format("ForensicsView.Title", arg0);
    }

    /**
     * Key {@code ForensicsView.Title}: {@code SCM Forensics of ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code SCM Forensics of ''{0}''}
     */
    public static Localizable _ForensicsView_Title(Object arg0) {
        return new Localizable(holder, "ForensicsView.Title", arg0);
    }

    /**
     * Key {@code TrendChart.Added.Legend.Label}: {@code Added lines}.
     * 
     * @return
     *     {@code Added lines}
     */
    public static String TrendChart_Added_Legend_Label() {
        return holder.format("TrendChart.Added.Legend.Label");
    }

    /**
     * Key {@code TrendChart.Added.Legend.Label}: {@code Added lines}.
     * 
     * @return
     *     {@code Added lines}
     */
    public static Localizable _TrendChart_Added_Legend_Label() {
        return new Localizable(holder, "TrendChart.Added.Legend.Label");
    }

    /**
     * Key {@code Forensics.Action}: {@code SCM Forensics}.
     * 
     * @return
     *     {@code SCM Forensics}
     */
    public static String Forensics_Action() {
        return holder.format("Forensics.Action");
    }

    /**
     * Key {@code Forensics.Action}: {@code SCM Forensics}.
     * 
     * @return
     *     {@code SCM Forensics}
     */
    public static Localizable _Forensics_Action() {
        return new Localizable(holder, "Forensics.Action");
    }

    /**
     * Key {@code Table.Column.Churn}: {@code Code Churn}.
     * 
     * @return
     *     {@code Code Churn}
     */
    public static String Table_Column_Churn() {
        return holder.format("Table.Column.Churn");
    }

    /**
     * Key {@code Table.Column.Churn}: {@code Code Churn}.
     * 
     * @return
     *     {@code Code Churn}
     */
    public static Localizable _Table_Column_Churn() {
        return new Localizable(holder, "Table.Column.Churn");
    }

    /**
     * Key {@code Table.Column.AuthorsSize}: {@code #Authors}.
     * 
     * @return
     *     {@code #Authors}
     */
    public static String Table_Column_AuthorsSize() {
        return holder.format("Table.Column.AuthorsSize");
    }

    /**
     * Key {@code Table.Column.AuthorsSize}: {@code #Authors}.
     * 
     * @return
     *     {@code #Authors}
     */
    public static Localizable _Table_Column_AuthorsSize() {
        return new Localizable(holder, "Table.Column.AuthorsSize");
    }

    /**
     * Key {@code FileView.Title}: {@code Details of {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Details of {0}}
     */
    public static String FileView_Title(Object arg0) {
        return holder.format("FileView.Title", arg0);
    }

    /**
     * Key {@code FileView.Title}: {@code Details of {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Details of {0}}
     */
    public static Localizable _FileView_Title(Object arg0) {
        return new Localizable(holder, "FileView.Title", arg0);
    }

    /**
     * Key {@code Step.Name}: {@code Mine SCM repository}.
     * 
     * @return
     *     {@code Mine SCM repository}
     */
    public static String Step_Name() {
        return holder.format("Step.Name");
    }

    /**
     * Key {@code Step.Name}: {@code Mine SCM repository}.
     * 
     * @return
     *     {@code Mine SCM repository}
     */
    public static Localizable _Step_Name() {
        return new Localizable(holder, "Step.Name");
    }

    /**
     * Key {@code Table.Column.LOC}: {@code #LoC}.
     * 
     * @return
     *     {@code #LoC}
     */
    public static String Table_Column_LOC() {
        return holder.format("Table.Column.LOC");
    }

    /**
     * Key {@code Table.Column.LOC}: {@code #LoC}.
     * 
     * @return
     *     {@code #LoC}
     */
    public static Localizable _Table_Column_LOC() {
        return new Localizable(holder, "Table.Column.LOC");
    }

    /**
     * Key {@code Table.Column.CommitId}: {@code Commit}.
     * 
     * @return
     *     {@code Commit}
     */
    public static String Table_Column_CommitId() {
        return holder.format("Table.Column.CommitId");
    }

    /**
     * Key {@code Table.Column.CommitId}: {@code Commit}.
     * 
     * @return
     *     {@code Commit}
     */
    public static Localizable _Table_Column_CommitId() {
        return new Localizable(holder, "Table.Column.CommitId");
    }

    /**
     * Key {@code Table.Column.CommitsSize}: {@code #Commits}.
     * 
     * @return
     *     {@code #Commits}
     */
    public static String Table_Column_CommitsSize() {
        return holder.format("Table.Column.CommitsSize");
    }

    /**
     * Key {@code Table.Column.CommitsSize}: {@code #Commits}.
     * 
     * @return
     *     {@code #Commits}
     */
    public static Localizable _Table_Column_CommitsSize() {
        return new Localizable(holder, "Table.Column.CommitsSize");
    }

    /**
     * Key {@code Table.Column.Author}: {@code Author}.
     * 
     * @return
     *     {@code Author}
     */
    public static String Table_Column_Author() {
        return holder.format("Table.Column.Author");
    }

    /**
     * Key {@code Table.Column.Author}: {@code Author}.
     * 
     * @return
     *     {@code Author}
     */
    public static Localizable _Table_Column_Author() {
        return new Localizable(holder, "Table.Column.Author");
    }

    /**
     * Key {@code Table.Column.AddedAt}: {@code Added}.
     * 
     * @return
     *     {@code Added}
     */
    public static String Table_Column_AddedAt() {
        return holder.format("Table.Column.AddedAt");
    }

    /**
     * Key {@code Table.Column.AddedAt}: {@code Added}.
     * 
     * @return
     *     {@code Added}
     */
    public static Localizable _Table_Column_AddedAt() {
        return new Localizable(holder, "Table.Column.AddedAt");
    }

    /**
     * Key {@code TrendChart.Churn.Legend.Added}: {@code Added}.
     * 
     * @return
     *     {@code Added}
     */
    public static String TrendChart_Churn_Legend_Added() {
        return holder.format("TrendChart.Churn.Legend.Added");
    }

    /**
     * Key {@code TrendChart.Churn.Legend.Added}: {@code Added}.
     * 
     * @return
     *     {@code Added}
     */
    public static Localizable _TrendChart_Churn_Legend_Added() {
        return new Localizable(holder, "TrendChart.Churn.Legend.Added");
    }

}
