/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.util;

import edu.hm.hafner.util.FilteredLog;
import hudson.ExtensionPoint;
import hudson.model.Run;
import hudson.scm.SCM;
import io.jenkins.plugins.forensics.util.CommitDecorator;
import io.jenkins.plugins.forensics.util.ScmResolver;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.List;
import java.util.Optional;

public abstract class CommitDecoratorFactory
implements ExtensionPoint {
    public abstract Optional<CommitDecorator> createCommitDecorator(SCM var1, FilteredLog var2);

    public static CommitDecorator findCommitDecorator(SCM scm, FilteredLog logger) {
        return CommitDecoratorFactory.findAllExtensions().stream().map(factory -> factory.createCommitDecorator(scm, logger)).flatMap(Optional::stream).findFirst().orElse(new CommitDecorator.NullDecorator());
    }

    public static CommitDecorator findCommitDecorator(Run<?, ?> run) {
        return CommitDecoratorFactory.findCommitDecorator(new ScmResolver().getScm(run), new FilteredLog("ignored"));
    }

    private static List<CommitDecoratorFactory> findAllExtensions() {
        return new JenkinsFacade().getExtensionsFor(CommitDecoratorFactory.class);
    }
}

