/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.echarts.AsyncConfigurableTrendJobAction;
import io.jenkins.plugins.echarts.BuildActionIterator;
import io.jenkins.plugins.forensics.miner.AddedVersusDeletedLinesForensicsSeriesBuilder;
import io.jenkins.plugins.forensics.miner.AddedVersusDeletedLinesTrendChart;
import io.jenkins.plugins.forensics.miner.CodeMetricTrendChart;
import io.jenkins.plugins.forensics.miner.FilesCountTrendChart;
import io.jenkins.plugins.forensics.miner.ForensicsBuildAction;
import io.jenkins.plugins.forensics.miner.Messages;
import io.jenkins.plugins.forensics.miner.RelativeCountForensicsSeriesBuilder;
import io.jenkins.plugins.forensics.miner.RelativeCountTrendChart;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.Strings;

public class ForensicsJobAction
extends AsyncConfigurableTrendJobAction<ForensicsBuildAction> {
    static final String ICON = "symbol-solid/microscope plugin-font-awesome-api";
    static final String FORENSICS_ID = "forensics";
    private static final JacksonFacade JACKSON_FACADE = new JacksonFacade();
    private final String scmKey;

    public String getScmKey() {
        return this.scmKey;
    }

    protected Iterable<? extends BuildResult<ForensicsBuildAction>> createBuildHistory() {
        return this::createIterator;
    }

    @NonNull
    @VisibleForTesting
    BuildActionIterator<ForensicsBuildAction> createIterator() {
        Predicate<ForensicsBuildAction> predicate = a -> this.scmKey.equals(a.getScmKey());
        Run lastCompletedBuild = this.getOwner().getLastCompletedBuild();
        Optional<Object> latestAction = lastCompletedBuild == null ? Optional.empty() : lastCompletedBuild.getActions(ForensicsBuildAction.class).stream().filter(predicate).findAny();
        return new BuildActionIterator(ForensicsBuildAction.class, latestAction, predicate);
    }

    protected LinesChartModel createChartModel(String configuration) {
        return this.createChart(this.createBuildHistory(), configuration);
    }

    public ForensicsJobAction(Job<?, ?> owner, String scmKey) {
        super(owner, ForensicsBuildAction.class);
        this.scmKey = scmKey;
    }

    public String getDisplayName() {
        return Messages.Forensics_Action();
    }

    @CheckForNull
    public String getIconFileName() {
        return ICON;
    }

    public String getUrlName() {
        return FORENSICS_ID;
    }

    LinesChartModel createChart(Iterable<? extends BuildResult<ForensicsBuildAction>> buildHistory, String configuration) {
        ChartModelConfiguration modelConfiguration = ChartModelConfiguration.fromJson((String)configuration);
        ChartType chart = this.getChart(configuration);
        if (chart == ChartType.LOC) {
            return new CodeMetricTrendChart().create(buildHistory, modelConfiguration);
        }
        if (chart == ChartType.DELTA) {
            return new AddedVersusDeletedLinesTrendChart().create(buildHistory, modelConfiguration, new AddedVersusDeletedLinesForensicsSeriesBuilder());
        }
        if (chart == ChartType.COUNT) {
            return new RelativeCountTrendChart().create(buildHistory, modelConfiguration, new RelativeCountForensicsSeriesBuilder());
        }
        return new FilesCountTrendChart().create(buildHistory, modelConfiguration);
    }

    private ChartType getChart(String configuration) {
        String type = JACKSON_FACADE.getString(configuration, "chartType", "files");
        for (ChartType chartType : ChartType.values()) {
            if (!Strings.CI.equals((CharSequence)type, (CharSequence)chartType.name())) continue;
            return chartType;
        }
        return ChartType.FILES;
    }

    static enum ChartType {
        FILES,
        LOC,
        DELTA,
        COUNT;

    }
}

