/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.reference;

import edu.hm.hafner.util.Generated;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import io.jenkins.plugins.forensics.reference.ReferenceRecorder;
import io.jenkins.plugins.forensics.reference.SimpleReferenceRecorder;
import java.util.Objects;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractObjectAssert;

@Generated(value={"assertj-assertions-generator"})
public class ReferenceRecorderAssert
extends AbstractObjectAssert<ReferenceRecorderAssert, ReferenceRecorder> {
    public ReferenceRecorderAssert(ReferenceRecorder actual) {
        super((Object)actual, ReferenceRecorderAssert.class);
    }

    @CheckReturnValue
    public static ReferenceRecorderAssert assertThat(ReferenceRecorder actual) {
        return new ReferenceRecorderAssert(actual);
    }

    public ReferenceRecorderAssert isConsiderRunningBuild() {
        this.isNotNull();
        if (!((ReferenceRecorder)this.actual).isConsiderRunningBuild()) {
            this.failWithMessage("\nExpecting that actual ReferenceRecorder is consider running build but is not.", new Object[0]);
        }
        return this;
    }

    public ReferenceRecorderAssert isNotConsiderRunningBuild() {
        this.isNotNull();
        if (((ReferenceRecorder)this.actual).isConsiderRunningBuild()) {
            this.failWithMessage("\nExpecting that actual ReferenceRecorder is not consider running build but is.", new Object[0]);
        }
        return this;
    }

    public ReferenceRecorderAssert hasDescriptor(SimpleReferenceRecorder.SimpleReferenceRecorderDescriptor descriptor) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting descriptor of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SimpleReferenceRecorder.SimpleReferenceRecorderDescriptor actualDescriptor = ((ReferenceRecorder)this.actual).getDescriptor();
        if (!Objects.deepEquals(actualDescriptor, descriptor)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, descriptor, actualDescriptor});
        }
        return this;
    }

    public ReferenceRecorderAssert isLatestBuildIfNotFound() {
        this.isNotNull();
        if (!((ReferenceRecorder)this.actual).isLatestBuildIfNotFound()) {
            this.failWithMessage("\nExpecting that actual ReferenceRecorder is latest build if not found but is not.", new Object[0]);
        }
        return this;
    }

    public ReferenceRecorderAssert isNotLatestBuildIfNotFound() {
        this.isNotNull();
        if (((ReferenceRecorder)this.actual).isLatestBuildIfNotFound()) {
            this.failWithMessage("\nExpecting that actual ReferenceRecorder is not latest build if not found but is.", new Object[0]);
        }
        return this;
    }

    public ReferenceRecorderAssert hasReferenceJob(String referenceJob) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting referenceJob of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualReferenceJob = ((ReferenceRecorder)this.actual).getReferenceJob();
        if (!Objects.deepEquals(actualReferenceJob, referenceJob)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, referenceJob, actualReferenceJob});
        }
        return this;
    }

    public ReferenceRecorderAssert hasRequiredBuildResult(String requiredBuildResult) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting requiredBuildResult of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualRequiredBuildResult = ((ReferenceRecorder)this.actual).getRequiredBuildResult();
        if (!Objects.deepEquals(actualRequiredBuildResult, requiredBuildResult)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, requiredBuildResult, actualRequiredBuildResult});
        }
        return this;
    }

    public ReferenceRecorderAssert hasRequiredMonitorService(BuildStepMonitor requiredMonitorService) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting requiredMonitorService of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        BuildStepMonitor actualRequiredMonitorService = ((ReferenceRecorder)this.actual).getRequiredMonitorService();
        if (!Objects.deepEquals(actualRequiredMonitorService, requiredMonitorService)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, requiredMonitorService, actualRequiredMonitorService});
        }
        return this;
    }

    public ReferenceRecorderAssert hasRequiredResult(Result requiredResult) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting requiredResult of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Result actualRequiredResult = ((ReferenceRecorder)this.actual).getRequiredResult();
        if (!Objects.deepEquals(actualRequiredResult, requiredResult)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, requiredResult, actualRequiredResult});
        }
        return this;
    }

    public ReferenceRecorderAssert hasScm(String scm) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting scm of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualScm = ((ReferenceRecorder)this.actual).getScm();
        if (!Objects.deepEquals(actualScm, scm)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, scm, actualScm});
        }
        return this;
    }

    public ReferenceRecorderAssert hasTargetBranch(String targetBranch) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting targetBranch of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualTargetBranch = ((ReferenceRecorder)this.actual).getTargetBranch();
        if (!Objects.deepEquals(actualTargetBranch, targetBranch)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, targetBranch, actualTargetBranch});
        }
        return this;
    }
}

