/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.delta;

import edu.hm.hafner.util.Generated;
import io.jenkins.plugins.forensics.delta.FileChanges;
import io.jenkins.plugins.forensics.delta.FileEditType;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;

@Generated(value={"assertj-assertions-generator"})
public class FileChangesAssert
extends AbstractObjectAssert<FileChangesAssert, FileChanges> {
    public FileChangesAssert(FileChanges actual) {
        super((Object)actual, FileChangesAssert.class);
    }

    @CheckReturnValue
    public static FileChangesAssert assertThat(FileChanges actual) {
        return new FileChangesAssert(actual);
    }

    public FileChangesAssert hasChanges(Map changes) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting changes of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map actualChanges = ((FileChanges)this.actual).getChanges();
        if (!Objects.deepEquals(actualChanges, changes)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, changes, actualChanges});
        }
        return this;
    }

    public FileChangesAssert hasFileContent(String fileContent) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileContent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualFileContent = ((FileChanges)this.actual).getFileContent();
        if (!Objects.deepEquals(actualFileContent, fileContent)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileContent, actualFileContent});
        }
        return this;
    }

    public FileChangesAssert hasFileEditType(FileEditType fileEditType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileEditType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        FileEditType actualFileEditType = ((FileChanges)this.actual).getFileEditType();
        if (!Objects.deepEquals(actualFileEditType, fileEditType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileEditType, actualFileEditType});
        }
        return this;
    }

    public FileChangesAssert hasFileName(String fileName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualFileName = ((FileChanges)this.actual).getFileName();
        if (!Objects.deepEquals(actualFileName, fileName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileName, actualFileName});
        }
        return this;
    }

    public FileChangesAssert hasModifiedLines(Integer ... modifiedLines) {
        this.isNotNull();
        if (modifiedLines == null) {
            this.failWithMessage("Expecting modifiedLines parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileChanges)this.actual).getModifiedLines(), (Object[])modifiedLines);
        return this;
    }

    public FileChangesAssert hasModifiedLines(Collection<? extends Integer> modifiedLines) {
        this.isNotNull();
        if (modifiedLines == null) {
            this.failWithMessage("Expecting modifiedLines parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileChanges)this.actual).getModifiedLines(), modifiedLines.toArray());
        return this;
    }

    public FileChangesAssert hasOnlyModifiedLines(Integer ... modifiedLines) {
        this.isNotNull();
        if (modifiedLines == null) {
            this.failWithMessage("Expecting modifiedLines parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileChanges)this.actual).getModifiedLines(), (Object[])modifiedLines);
        return this;
    }

    public FileChangesAssert hasOnlyModifiedLines(Collection<? extends Integer> modifiedLines) {
        this.isNotNull();
        if (modifiedLines == null) {
            this.failWithMessage("Expecting modifiedLines parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileChanges)this.actual).getModifiedLines(), modifiedLines.toArray());
        return this;
    }

    public FileChangesAssert doesNotHaveModifiedLines(Integer ... modifiedLines) {
        this.isNotNull();
        if (modifiedLines == null) {
            this.failWithMessage("Expecting modifiedLines parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileChanges)this.actual).getModifiedLines(), (Object[])modifiedLines);
        return this;
    }

    public FileChangesAssert doesNotHaveModifiedLines(Collection<? extends Integer> modifiedLines) {
        this.isNotNull();
        if (modifiedLines == null) {
            this.failWithMessage("Expecting modifiedLines parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileChanges)this.actual).getModifiedLines(), modifiedLines.toArray());
        return this;
    }

    public FileChangesAssert hasNoModifiedLines() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have modifiedLines but had :\n  <%s>";
        if (((FileChanges)this.actual).getModifiedLines().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((FileChanges)this.actual).getModifiedLines()});
        }
        return this;
    }

    public FileChangesAssert hasOldFileName(String oldFileName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting oldFileName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualOldFileName = ((FileChanges)this.actual).getOldFileName();
        if (!Objects.deepEquals(actualOldFileName, oldFileName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, oldFileName, actualOldFileName});
        }
        return this;
    }
}

