/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.blame;

import edu.hm.hafner.util.Generated;
import io.jenkins.plugins.forensics.blame.FileBlame;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;

@Generated(value={"assertj-assertions-generator"})
public class FileBlameAssert
extends AbstractObjectAssert<FileBlameAssert, FileBlame> {
    public FileBlameAssert(FileBlame actual) {
        super((Object)actual, FileBlameAssert.class);
    }

    @CheckReturnValue
    public static FileBlameAssert assertThat(FileBlame actual) {
        return new FileBlameAssert(actual);
    }

    public FileBlameAssert hasFileName(String fileName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualFileName = ((FileBlame)this.actual).getFileName();
        if (!Objects.deepEquals(actualFileName, fileName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileName, actualFileName});
        }
        return this;
    }

    public FileBlameAssert hasLines(Integer ... lines) {
        this.isNotNull();
        if (lines == null) {
            this.failWithMessage("Expecting lines parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileBlame)this.actual).getLines(), (Object[])lines);
        return this;
    }

    public FileBlameAssert hasLines(Collection<? extends Integer> lines) {
        this.isNotNull();
        if (lines == null) {
            this.failWithMessage("Expecting lines parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileBlame)this.actual).getLines(), lines.toArray());
        return this;
    }

    public FileBlameAssert hasOnlyLines(Integer ... lines) {
        this.isNotNull();
        if (lines == null) {
            this.failWithMessage("Expecting lines parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileBlame)this.actual).getLines(), (Object[])lines);
        return this;
    }

    public FileBlameAssert hasOnlyLines(Collection<? extends Integer> lines) {
        this.isNotNull();
        if (lines == null) {
            this.failWithMessage("Expecting lines parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileBlame)this.actual).getLines(), lines.toArray());
        return this;
    }

    public FileBlameAssert doesNotHaveLines(Integer ... lines) {
        this.isNotNull();
        if (lines == null) {
            this.failWithMessage("Expecting lines parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileBlame)this.actual).getLines(), (Object[])lines);
        return this;
    }

    public FileBlameAssert doesNotHaveLines(Collection<? extends Integer> lines) {
        this.isNotNull();
        if (lines == null) {
            this.failWithMessage("Expecting lines parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileBlame)this.actual).getLines(), lines.toArray());
        return this;
    }

    public FileBlameAssert hasNoLines() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have lines but had :\n  <%s>";
        if (((FileBlame)this.actual).getLines().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((FileBlame)this.actual).getLines()});
        }
        return this;
    }
}

