/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.util.FilteredLog;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import io.jenkins.plugins.forensics.miner.RepositoryMiner;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class MinerFactory
implements ExtensionPoint {
    private static final Function<Optional<RepositoryMiner>, Stream<? extends RepositoryMiner>> OPTIONAL_MAPPER = o -> o.map(Stream::of).orElseGet(Stream::empty);

    public abstract Optional<RepositoryMiner> createMiner(SCM var1, Run<?, ?> var2, FilePath var3, TaskListener var4, FilteredLog var5);

    private static RepositoryMiner createNullMiner(FilteredLog logger) {
        if (MinerFactory.findAllExtensions().isEmpty()) {
            logger.logInfo("-> No miner installed yet. You need to install the `git-forensics` plugin to enable mining of Git repositories.");
        } else {
            logger.logInfo("-> No suitable miner found.");
        }
        return new RepositoryMiner.NullMiner();
    }

    static RepositoryMiner findMiner(SCM scm, Run<?, ?> run, FilePath workTree, TaskListener listener, FilteredLog logger) {
        return MinerFactory.findAllExtensions().stream().map(minerFactory -> minerFactory.createMiner(scm, run, workTree, listener, logger)).flatMap(OPTIONAL_MAPPER).findFirst().orElseGet(() -> MinerFactory.createNullMiner(logger));
    }

    private static List<MinerFactory> findAllExtensions() {
        return new JenkinsFacade().getExtensionsFor(MinerFactory.class);
    }
}

