/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.echarts.JacksonFacade;
import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.plugins.datatables.DefaultAsyncTableContentProvider;
import io.jenkins.plugins.forensics.miner.FileDetailsView;
import io.jenkins.plugins.forensics.miner.FileStatistics;
import io.jenkins.plugins.forensics.miner.ForensicsTableModel;
import io.jenkins.plugins.forensics.miner.Messages;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import io.jenkins.plugins.forensics.miner.SizePieChart;
import io.jenkins.plugins.forensics.util.CommitDecorator;
import io.jenkins.plugins.forensics.util.CommitDecoratorFactory;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ForensicsViewModel
extends DefaultAsyncTableContentProvider
implements ModelObject {
    private final Run<?, ?> owner;
    private final RepositoryStatistics repositoryStatistics;
    private final String scmKey;

    ForensicsViewModel(Run<?, ?> owner, RepositoryStatistics repositoryStatistics, String scmKey) {
        this.owner = owner;
        this.repositoryStatistics = repositoryStatistics;
        this.scmKey = scmKey;
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public String getDisplayName() {
        return Messages.Forensics_Action();
    }

    public String getScmKey() {
        return this.scmKey;
    }

    public ForensicsTableModel getTableModel(String id) {
        return new ForensicsTableModel(this.repositoryStatistics);
    }

    @JavaScriptMethod
    public String getAuthorsModel() {
        return new JacksonFacade().toJson((Object)new SizePieChart().create(this.repositoryStatistics, FileStatistics::getNumberOfAuthors, 5, 10, 15, 25, 50));
    }

    @JavaScriptMethod
    public String getCommitsModel() {
        return new JacksonFacade().toJson((Object)new SizePieChart().create(this.repositoryStatistics, FileStatistics::getNumberOfCommits, 5, 10, 25, 50, 100, 250));
    }

    public Object getDynamic(String link, StaplerRequest2 request, StaplerResponse2 response) {
        try {
            CommitDecorator decorator = CommitDecoratorFactory.findCommitDecorator(this.owner);
            return new FileDetailsView(this.owner, link, this.repositoryStatistics, decorator);
        }
        catch (NoSuchElementException nse) {
            try {
                response.sendRedirect2("../");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this;
        }
    }
}

