/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.LineSeries;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.hm.hafner.echarts.LinesDataSet;
import edu.hm.hafner.echarts.SeriesBuilder;
import io.jenkins.plugins.echarts.JenkinsPalette;

class AddedVersusDeletedLinesTrendChart {
    AddedVersusDeletedLinesTrendChart() {
    }

    <T> LinesChartModel create(Iterable<? extends BuildResult<T>> results, ChartModelConfiguration configuration, SeriesBuilder<T> seriesBuilder) {
        LinesDataSet dataSet = seriesBuilder.createDataSet(configuration, results);
        LinesChartModel model = new LinesChartModel(dataSet);
        LineSeries newSeries = this.getSeries(dataSet, "Added Lines", JenkinsPalette.GREEN, "added");
        LineSeries fixedSeries = this.getSeries(dataSet, "Deleted Lines", JenkinsPalette.RED, "deleted");
        model.addSeries(new LineSeries[]{newSeries, fixedSeries});
        return model;
    }

    private LineSeries getSeries(LinesDataSet dataSet, String name, JenkinsPalette color, String dataSetId) {
        LineSeries newSeries = new LineSeries(name, color.normal(), LineSeries.StackedMode.SEPARATE_LINES, LineSeries.FilledMode.FILLED);
        newSeries.addAll(dataSet.getSeries(dataSetId));
        return newSeries;
    }
}

