/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.LineSeries;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.hm.hafner.echarts.LinesDataSet;
import edu.hm.hafner.echarts.SeriesBuilder;
import io.jenkins.plugins.echarts.JenkinsPalette;

class RelativeCountTrendChart {
    RelativeCountTrendChart() {
    }

    <T> LinesChartModel create(Iterable<? extends BuildResult<T>> results, ChartModelConfiguration configuration, SeriesBuilder<T> seriesBuilder) {
        LinesDataSet dataSet = seriesBuilder.createDataSet(configuration, results);
        LinesChartModel model = new LinesChartModel(dataSet);
        if (dataSet.getDomainAxisSize() > 0) {
            LineSeries authors = this.getSeries(dataSet, "Authors", JenkinsPalette.BLUE, "authors");
            LineSeries commits = this.getSeries(dataSet, "Commits", JenkinsPalette.GREEN, "commits");
            LineSeries files = this.getSeries(dataSet, "Modified files", JenkinsPalette.ORANGE, "files");
            model.addSeries(new LineSeries[]{authors, commits, files});
        }
        return model;
    }

    private LineSeries getSeries(LinesDataSet dataSet, String name, JenkinsPalette color, String dataSetId) {
        LineSeries series = new LineSeries(name, color.normal(), LineSeries.StackedMode.SEPARATE_LINES, LineSeries.FilledMode.LINES);
        series.addAll(dataSet.getSeries(dataSetId));
        return series;
    }
}

