/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import io.jenkins.plugins.forensics.miner.CommitStatistics;
import io.jenkins.plugins.forensics.miner.CommitStatisticsJobAction;
import io.jenkins.plugins.forensics.reference.ReferenceBuild;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;

public class CommitStatisticsBuildAction
extends InvisibleAction
implements SimpleBuildStep.LastBuildAction,
RunAction2,
Serializable {
    private static final long serialVersionUID = -263122257268060032L;
    @SuppressFBWarnings(value={"SE"}, justification="transient field owner ist restored using a Jenkins callback")
    private transient Run<?, ?> owner;
    private final String scmKey;
    private final CommitStatistics commitStatistics;

    public CommitStatisticsBuildAction(Run<?, ?> owner, String scmKey, CommitStatistics commitStatistics) {
        this.owner = owner;
        this.scmKey = scmKey;
        this.commitStatistics = commitStatistics;
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public String getScmKey() {
        return this.scmKey;
    }

    public CommitStatistics getCommitStatistics() {
        return this.commitStatistics;
    }

    public boolean hasReferenceBuild() {
        ReferenceBuild referenceBuildAction = this.getReferenceBuild();
        return referenceBuildAction != null && referenceBuildAction.hasReferenceBuild();
    }

    @CheckForNull
    public ReferenceBuild getReferenceBuild() {
        return (ReferenceBuild)this.getOwner().getAction(ReferenceBuild.class);
    }

    public String getReferenceBuildLink() {
        ReferenceBuild build = this.getReferenceBuild();
        if (build == null) {
            return "-";
        }
        return build.getReferenceLink();
    }

    public String toString() {
        return "%s [%s]".formatted(this.scmKey, this.commitStatistics);
    }

    public void onAttached(Run<?, ?> run) {
        this.owner = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.owner = run;
    }

    public Collection<? extends Action> getProjectActions() {
        return Set.of(new CommitStatisticsJobAction(this.owner.getParent(), this.scmKey));
    }
}

