/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.util.Generated;
import io.jenkins.plugins.forensics.miner.CommitDiffItem;
import io.jenkins.plugins.forensics.miner.FileStatistics;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;

@Generated(value={"assertj-assertions-generator"})
public class FileStatisticsAssert
extends AbstractObjectAssert<FileStatisticsAssert, FileStatistics> {
    public FileStatisticsAssert(FileStatistics actual) {
        super((Object)actual, FileStatisticsAssert.class);
    }

    @CheckReturnValue
    public static FileStatisticsAssert assertThat(FileStatistics actual) {
        return new FileStatisticsAssert(actual);
    }

    public FileStatisticsAssert hasAbsoluteChurn(int absoluteChurn) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting absoluteChurn of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualAbsoluteChurn = ((FileStatistics)this.actual).getAbsoluteChurn();
        if (actualAbsoluteChurn != absoluteChurn) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, absoluteChurn, actualAbsoluteChurn});
        }
        return this;
    }

    public FileStatisticsAssert hasCommits(CommitDiffItem ... commits) {
        this.isNotNull();
        if (commits == null) {
            this.failWithMessage("Expecting commits parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileStatistics)this.actual).getCommits(), (Object[])commits);
        return this;
    }

    public FileStatisticsAssert hasCommits(Collection<? extends CommitDiffItem> commits) {
        this.isNotNull();
        if (commits == null) {
            this.failWithMessage("Expecting commits parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileStatistics)this.actual).getCommits(), commits.toArray());
        return this;
    }

    public FileStatisticsAssert hasOnlyCommits(CommitDiffItem ... commits) {
        this.isNotNull();
        if (commits == null) {
            this.failWithMessage("Expecting commits parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileStatistics)this.actual).getCommits(), (Object[])commits);
        return this;
    }

    public FileStatisticsAssert hasOnlyCommits(Collection<? extends CommitDiffItem> commits) {
        this.isNotNull();
        if (commits == null) {
            this.failWithMessage("Expecting commits parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileStatistics)this.actual).getCommits(), commits.toArray());
        return this;
    }

    public FileStatisticsAssert doesNotHaveCommits(CommitDiffItem ... commits) {
        this.isNotNull();
        if (commits == null) {
            this.failWithMessage("Expecting commits parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileStatistics)this.actual).getCommits(), (Object[])commits);
        return this;
    }

    public FileStatisticsAssert doesNotHaveCommits(Collection<? extends CommitDiffItem> commits) {
        this.isNotNull();
        if (commits == null) {
            this.failWithMessage("Expecting commits parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileStatistics)this.actual).getCommits(), commits.toArray());
        return this;
    }

    public FileStatisticsAssert hasNoCommits() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have commits but had :\n  <%s>";
        if (((FileStatistics)this.actual).getCommits().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((FileStatistics)this.actual).getCommits()});
        }
        return this;
    }

    public FileStatisticsAssert hasCreationTime(int creationTime) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting creationTime of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualCreationTime = ((FileStatistics)this.actual).getCreationTime();
        if (actualCreationTime != creationTime) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, creationTime, actualCreationTime});
        }
        return this;
    }

    public FileStatisticsAssert hasFileName(String fileName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualFileName = ((FileStatistics)this.actual).getFileName();
        if (!Objects.deepEquals(actualFileName, fileName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileName, actualFileName});
        }
        return this;
    }

    public FileStatisticsAssert hasLastModificationTime(int lastModificationTime) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lastModificationTime of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualLastModificationTime = ((FileStatistics)this.actual).getLastModificationTime();
        if (actualLastModificationTime != lastModificationTime) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lastModificationTime, actualLastModificationTime});
        }
        return this;
    }

    public FileStatisticsAssert hasLinesOfCode(int linesOfCode) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting linesOfCode of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualLinesOfCode = ((FileStatistics)this.actual).getLinesOfCode();
        if (actualLinesOfCode != linesOfCode) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, linesOfCode, actualLinesOfCode});
        }
        return this;
    }

    public FileStatisticsAssert hasNumberOfAuthors(int numberOfAuthors) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting numberOfAuthors of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualNumberOfAuthors = ((FileStatistics)this.actual).getNumberOfAuthors();
        if (actualNumberOfAuthors != numberOfAuthors) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, numberOfAuthors, actualNumberOfAuthors});
        }
        return this;
    }

    public FileStatisticsAssert hasNumberOfCommits(int numberOfCommits) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting numberOfCommits of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualNumberOfCommits = ((FileStatistics)this.actual).getNumberOfCommits();
        if (actualNumberOfCommits != numberOfCommits) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, numberOfCommits, actualNumberOfCommits});
        }
        return this;
    }
}

