/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.reference;

import edu.hm.hafner.util.VisibleForTesting;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.plugins.bootstrap5.MessagesViewModel;
import io.jenkins.plugins.forensics.reference.Messages;
import io.jenkins.plugins.util.JenkinsFacade;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jenkins.model.RunAction2;
import org.apache.commons.lang3.Strings;
import org.kohsuke.stapler.StaplerProxy;

public class ReferenceBuild
implements RunAction2,
Serializable,
StaplerProxy {
    private static final long serialVersionUID = -4549516129641755356L;
    public static final String NO_REFERENCE_BUILD = "-";
    static final String REFERENCE_DETAILS_URL = "reference";
    private final String referenceBuildId;
    private Result requiredResult;
    private final JenkinsFacade jenkinsFacade;
    private final ArrayList<String> messages;
    private transient Run<?, ?> owner;

    public static String getReferenceBuildLink(String referenceBuildId) {
        if (!ReferenceBuild.isValidBuildId(referenceBuildId)) {
            return NO_REFERENCE_BUILD;
        }
        JenkinsFacade jenkinsFacade = new JenkinsFacade();
        Optional possibleReferenceBuild = jenkinsFacade.getBuild(referenceBuildId);
        if (possibleReferenceBuild.isPresent()) {
            return ReferenceBuild.createLink((Run)possibleReferenceBuild.get(), jenkinsFacade);
        }
        return "#%s".formatted(referenceBuildId);
    }

    public ReferenceBuild(Run<?, ?> owner, List<String> messages, Result requiredResult) {
        this(owner, messages, NO_REFERENCE_BUILD, requiredResult);
    }

    public ReferenceBuild(Run<?, ?> owner, List<String> messages, Result requiredResult, Run<?, ?> referenceBuild) {
        this(owner, messages, referenceBuild.getExternalizableId(), requiredResult);
    }

    @Deprecated
    public ReferenceBuild(Run<?, ?> owner, List<String> messages) {
        this(owner, messages, NO_REFERENCE_BUILD, Result.UNSTABLE);
    }

    @Deprecated
    public ReferenceBuild(Run<?, ?> owner, List<String> messages, Run<?, ?> referenceBuild) {
        this(owner, messages, referenceBuild.getExternalizableId(), Result.UNSTABLE);
    }

    private ReferenceBuild(Run<?, ?> owner, List<String> messages, String referenceBuildId, Result requiredResult) {
        this(owner, messages, referenceBuildId, requiredResult, new JenkinsFacade());
    }

    @VisibleForTesting
    ReferenceBuild(Run<?, ?> owner, List<String> messages, String referenceBuildId, Result requiredResult, JenkinsFacade jenkinsFacade) {
        this.owner = owner;
        this.messages = new ArrayList<String>(messages);
        this.referenceBuildId = referenceBuildId;
        this.requiredResult = requiredResult;
        this.jenkinsFacade = jenkinsFacade;
    }

    protected Object readResolve() {
        if (this.requiredResult == null) {
            this.requiredResult = Result.UNSTABLE;
        }
        return this;
    }

    public void onAttached(Run<?, ?> run) {
        this.owner = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.onAttached(run);
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public String getReferenceLink() {
        return this.getReferenceBuild().map(run -> ReferenceBuild.createLink(run, this.jenkinsFacade)).orElse(String.format("Reference build '%s' not found anymore - maybe the build has been renamed or deleted?", this.getReferenceBuildId()));
    }

    private static String createLink(Run<?, ?> run, JenkinsFacade jenkinsFacade) {
        return ((ContainerTag)((ContainerTag)TagCreator.a().withText(run.getFullDisplayName()).withHref(jenkinsFacade.getAbsoluteUrl(new String[]{run.getUrl()}))).withClasses(new String[]{"model-link", "inside"})).render();
    }

    public boolean hasReferenceBuild() {
        return ReferenceBuild.isValidBuildId(this.referenceBuildId);
    }

    private static boolean isValidBuildId(String buildId) {
        return !Strings.CS.equals(buildId, NO_REFERENCE_BUILD);
    }

    public String getReferenceBuildId() {
        return this.referenceBuildId;
    }

    public Optional<Run<?, ?>> getReferenceBuild() {
        if (this.hasReferenceBuild()) {
            return this.jenkinsFacade.getBuild(this.referenceBuildId);
        }
        return Optional.empty();
    }

    public Result getRequiredResult() {
        return this.requiredResult;
    }

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return REFERENCE_DETAILS_URL;
    }

    public Object getTarget() {
        return new MessagesViewModel(this.getOwner(), Messages.Messages_DisplayName(), this.messages);
    }
}

