/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.util.Generated;
import edu.hm.hafner.util.TreeString;
import java.io.Serializable;
import java.util.Objects;
import java.util.StringJoiner;

public class CommitDiffItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String NO_FILE_NAME = "/dev/null";
    private static final TreeString NO_FILE_AS_TREE_STRING = TreeString.valueOf((String)"/dev/null");
    private String id;
    private String author;
    private final int time;
    private int totalAddedLines;
    private int totalDeletedLines;
    private TreeString oldPath = NO_FILE_AS_TREE_STRING;
    private TreeString newPath = NO_FILE_AS_TREE_STRING;

    public CommitDiffItem(String id, String author, int time) {
        this.id = id.intern();
        this.author = author.intern();
        this.time = time;
    }

    protected Object readResolve() {
        this.id = this.id.intern();
        this.author = this.author.intern();
        return this;
    }

    public CommitDiffItem(CommitDiffItem copy) {
        this(copy.getId(), copy.getAuthor(), copy.getTime());
    }

    public String getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public int getTime() {
        return this.time;
    }

    public int getTotalAddedLines() {
        return this.totalAddedLines;
    }

    public int getTotalDeletedLines() {
        return this.totalDeletedLines;
    }

    public String getOldPath() {
        return this.oldPath.toString();
    }

    public boolean isDelete() {
        return this.hasOldPath() && !this.hasNewPath();
    }

    public boolean isMove() {
        return this.hasOldPath() && this.hasNewPath();
    }

    boolean hasOldPath() {
        return !NO_FILE_NAME.equals(this.getOldPath());
    }

    public String getNewPath() {
        return this.newPath.toString();
    }

    private boolean hasNewPath() {
        return !NO_FILE_NAME.equals(this.getNewPath());
    }

    public CommitDiffItem addLines(int addedLines) {
        this.totalAddedLines += addedLines;
        return this;
    }

    public CommitDiffItem deleteLines(int deletedLines) {
        this.totalDeletedLines += deletedLines;
        return this;
    }

    public CommitDiffItem setOldPath(TreeString oldPath) {
        this.oldPath = oldPath;
        return this;
    }

    public CommitDiffItem setNewPath(TreeString newPath) {
        this.newPath = newPath;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitDiffItem commit = (CommitDiffItem)o;
        return this.time == commit.time && this.totalAddedLines == commit.totalAddedLines && this.totalDeletedLines == commit.totalDeletedLines && this.id.equals(commit.id) && this.author.equals(commit.author) && this.oldPath.equals((Object)commit.oldPath) && this.newPath.equals((Object)commit.newPath);
    }

    @Generated
    public int hashCode() {
        return Objects.hash(this.id, this.author, this.time, this.totalAddedLines, this.totalDeletedLines, this.oldPath, this.newPath);
    }

    @Generated
    public String toString() {
        return new StringJoiner(", ", CommitDiffItem.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("author='" + this.author + "'").add("time=" + this.time).add("totalAddedLines=" + this.totalAddedLines).add("totalDeletedLines=" + this.totalDeletedLines).add("oldPath='" + String.valueOf(this.oldPath) + "'").add("newPath='" + String.valueOf(this.newPath) + "'").toString();
    }
}

