/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.LineSeries;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.hm.hafner.echarts.LinesDataSet;
import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.plugins.datatables.DefaultAsyncTableContentProvider;
import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.datatables.TableModel;
import io.jenkins.plugins.echarts.AsyncTrendChart;
import io.jenkins.plugins.echarts.JenkinsPalette;
import io.jenkins.plugins.forensics.miner.CommitDiffItem;
import io.jenkins.plugins.forensics.miner.FileStatistics;
import io.jenkins.plugins.forensics.miner.Messages;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import io.jenkins.plugins.forensics.util.CommitDecorator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class FileDetailsView
extends DefaultAsyncTableContentProvider
implements ModelObject,
AsyncTrendChart {
    private static final String FILE_NAME_PROPERTY = "fileName.";
    private final Run<?, ?> owner;
    private final String fileHash;
    private final RepositoryStatistics repositoryStatistics;
    private final CommitDecorator decorator;
    private final FileStatistics fileStatistics;

    public FileDetailsView(Run<?, ?> owner, String fileLink, RepositoryStatistics repositoryStatistics, CommitDecorator decorator) {
        this.owner = owner;
        this.fileHash = fileLink.substring(FILE_NAME_PROPERTY.length());
        this.repositoryStatistics = repositoryStatistics;
        this.decorator = decorator;
        this.fileStatistics = this.filterStatistics();
    }

    private FileStatistics filterStatistics() {
        return this.repositoryStatistics.getFileStatistics().stream().filter(f -> String.valueOf(f.getFileName().hashCode()).equals(this.fileHash)).findAny().orElseThrow(() -> new NoSuchElementException("No file found with hash code " + this.fileHash));
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public LinesChartModel createChartModel() {
        return new FileChurnTrendChart().create(this.fileStatistics, this.decorator);
    }

    @JavaScriptMethod
    public String getCommitUrl(String commit) {
        return this.decorator.getRawLink(commit);
    }

    @JavaScriptMethod
    public String getBuildTrendModel() {
        return new JacksonFacade().toJson((Object)this.createChartModel());
    }

    public boolean isTrendVisible() {
        return true;
    }

    public String getDisplayName() {
        return Messages.FileView_Title(FilenameUtils.getName((String)this.getFullPath()));
    }

    public String getFullPath() {
        return this.fileStatistics.getFileName();
    }

    public TableModel getTableModel(String id) {
        return new FileTableModel();
    }

    static class FileChurnTrendChart {
        private static final String ADDED_KEY = "added";
        private static final String DELETED_KEY = "deleted";

        FileChurnTrendChart() {
        }

        public LinesChartModel create(FileStatistics fileStatistics, CommitDecorator decorator) {
            LinesDataSet dataSet = this.createDataSetPerCommit(fileStatistics, decorator);
            LinesChartModel model = new LinesChartModel(dataSet);
            model.setDomainAxisItemName("Commit");
            LineSeries added = new LineSeries(Messages.TrendChart_Churn_Legend_Added(), JenkinsPalette.GREEN.normal(), LineSeries.StackedMode.SEPARATE_LINES, LineSeries.FilledMode.FILLED);
            added.addAll(dataSet.getSeries(ADDED_KEY));
            LineSeries deleted = new LineSeries(Messages.TrendChart_Churn_Legend_Deleted(), JenkinsPalette.RED.normal(), LineSeries.StackedMode.SEPARATE_LINES, LineSeries.FilledMode.FILLED);
            deleted.addAll(dataSet.getSeries(DELETED_KEY));
            model.addSeries(new LineSeries[]{added, deleted});
            return model;
        }

        private LinesDataSet createDataSetPerCommit(FileStatistics current, CommitDecorator decorator) {
            LinesDataSet model = new LinesDataSet();
            for (CommitDiffItem commit : current.getCommits()) {
                model.add(decorator.asText(commit.getId()), this.computeSeries(commit));
            }
            return model;
        }

        private Map<String, Integer> computeSeries(CommitDiffItem commit) {
            HashMap<String, Integer> commitChanges = new HashMap<String, Integer>();
            commitChanges.put(ADDED_KEY, commit.getTotalAddedLines());
            commitChanges.put(DELETED_KEY, commit.getTotalDeletedLines());
            return commitChanges;
        }
    }

    private class FileTableModel
    extends TableModel {
        private FileTableModel() {
        }

        public String getId() {
            return "forensics-details";
        }

        public List<TableColumn> getColumns() {
            ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
            columns.add(new TableColumn(Messages.Table_Column_CommitId(), "commitId"));
            columns.add(new TableColumn(Messages.Table_Column_Author(), "author"));
            columns.add(new TableColumn(Messages.Table_Column_AddedLines(), "addedLines"));
            columns.add(new TableColumn(Messages.Table_Column_DeletedLines(), "deletedLines"));
            return columns;
        }

        public List<Object> getRows() {
            return FileDetailsView.this.fileStatistics.getCommits().stream().map(commit -> new ForensicsRow((CommitDiffItem)commit, FileDetailsView.this.decorator)).collect(Collectors.toList());
        }
    }

    public static class ForensicsRow {
        private final String id;
        private final String author;
        private final int totalAddedLines;
        private final int totalDeletedLines;

        ForensicsRow(CommitDiffItem commit, CommitDecorator decorator) {
            this.id = decorator.asLink(commit.getId());
            this.author = commit.getAuthor();
            this.totalAddedLines = commit.getTotalAddedLines();
            this.totalDeletedLines = commit.getTotalDeletedLines();
        }

        public int getAddedLines() {
            return this.totalAddedLines;
        }

        public int getDeletedLines() {
            return this.totalDeletedLines;
        }

        public String getCommitId() {
            return this.id;
        }

        public String getAuthor() {
            return this.author;
        }
    }
}

