/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.util;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.triggers.SCMTriggerItem;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class ScmResolver {
    private static final List<SCM> EMPTY = Collections.emptyList();

    public SCM getScm(Run<?, ?> run) {
        Collection<? extends SCM> scms = this.getScms(run);
        if (scms.isEmpty()) {
            return new NullSCM();
        }
        return scms.iterator().next();
    }

    public Collection<? extends SCM> getScms(Run<?, ?> run, String keyFilter) {
        return this.getScms(run).stream().filter(r -> StringUtils.containsIgnoreCase((CharSequence)r.getKey(), (CharSequence)keyFilter)).collect(Collectors.toList());
    }

    public Collection<? extends SCM> getScms(Run<?, ?> run) {
        Collection<? extends SCM> allScms = this.findScms(run);
        Set ids = allScms.stream().map(SCM::getKey).collect(Collectors.toSet());
        ArrayList<SCM> uniqueScms = new ArrayList<SCM>();
        for (SCM sCM : allScms) {
            if (!ids.contains(sCM.getKey())) continue;
            uniqueScms.add(sCM);
            ids.remove(sCM.getKey());
        }
        return uniqueScms;
    }

    private Collection<? extends SCM> findScms(Run<?, ?> run) {
        WorkflowRun workflowRun;
        List scms;
        if (run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            return this.extractFromProject(build);
        }
        if (run instanceof WorkflowRun && !(scms = (workflowRun = (WorkflowRun)run).getSCMs()).isEmpty()) {
            return scms;
        }
        Job job = run.getParent();
        if (job instanceof SCMTriggerItem) {
            return this.extractFromPipeline(job);
        }
        return EMPTY;
    }

    private Collection<? extends SCM> extractFromPipeline(Job<?, ?> job) {
        WorkflowJob workflowJob;
        FlowDefinition definition;
        Collection scms = ((SCMTriggerItem)job).getSCMs();
        if (!scms.isEmpty()) {
            return scms;
        }
        if (job instanceof WorkflowJob && (definition = (workflowJob = (WorkflowJob)job).getDefinition()) instanceof CpsScmFlowDefinition) {
            CpsScmFlowDefinition flowDefinition = (CpsScmFlowDefinition)definition;
            return this.asCollection(flowDefinition.getScm());
        }
        return EMPTY;
    }

    private Collection<? extends SCM> extractFromProject(AbstractBuild<?, ?> run) {
        AbstractProject project = (AbstractProject)run.getParent();
        if (project.getScm() != null) {
            return this.asCollection(project.getScm());
        }
        SCM scm = project.getRootProject().getScm();
        if (scm != null) {
            return this.asCollection(scm);
        }
        return EMPTY;
    }

    private Set<SCM> asCollection(SCM scm) {
        return Set.of(scm);
    }
}

